/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.annotations.Initialise;
import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.callback.DirtyStateMonitor;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.dataflow.function.MergeProperty;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MergeMapToNodeFlowFunction<T>
implements TriggeredFlowFunction<T> {
    private final T result;
    private final List<MergeProperty<T, ?>> mergeProperties;
    private List<FlowFunction> triggerList = new ArrayList<FlowFunction>();
    @NoTriggerReference
    private final transient List<FlowFunction> nonTriggeringSources = new ArrayList<FlowFunction>();
    private final transient Set<FlowFunction<?>> requiredSet = new HashSet();
    private transient boolean allTriggersUpdated = false;
    @Inject
    public DirtyStateMonitor dirtyStateMonitor;

    public MergeMapToNodeFlowFunction(T result) {
        this(result, new ArrayList());
    }

    public MergeMapToNodeFlowFunction(@AssignToField(value="result") T result, @AssignToField(value="mergeProperties") List<MergeProperty<T, ?>> mergeProperties) {
        this.result = result;
        this.mergeProperties = mergeProperties;
    }

    @OnParentUpdate(value="triggerList")
    public void inputUpdated(FlowFunction<?> trigger) {
        if (!this.allTriggersUpdated) {
            this.requiredSet.remove(trigger);
            this.allTriggersUpdated = this.requiredSet.isEmpty();
        }
    }

    @OnParentUpdate(value="nonTriggeringSources")
    public void inputNonTriggeringUpdated(FlowFunction<?> trigger) {
        if (!this.allTriggersUpdated) {
            this.requiredSet.remove(trigger);
            this.allTriggersUpdated = this.requiredSet.isEmpty();
        }
    }

    @OnTrigger
    public boolean triggered() {
        if (this.allTriggersUpdated) {
            for (int i = 0; i < this.mergeProperties.size(); ++i) {
                this.mergeProperties.get(i).push(this.result);
            }
        }
        return this.allTriggersUpdated;
    }

    @Override
    public void parallel() {
    }

    @Override
    public boolean parallelCandidate() {
        return false;
    }

    @Override
    public boolean hasChanged() {
        return this.dirtyStateMonitor.isDirty(this);
    }

    public <R> void registerTrigger(MergeProperty<T, R> mergeProperty) {
        if (mergeProperty.isTriggering()) {
            this.triggerList.add(mergeProperty.getTrigger());
        } else {
            this.nonTriggeringSources.add(mergeProperty.getTrigger());
        }
        this.mergeProperties.add(mergeProperty);
    }

    @Override
    public T get() {
        return this.result;
    }

    @Initialise
    public void init() {
        this.allTriggersUpdated = false;
        this.triggerList.clear();
        this.mergeProperties.stream().map(MergeProperty::getTrigger).forEach(this.requiredSet::add);
    }

    @Override
    public void setUpdateTriggerNode(Object updateTriggerNode) {
    }

    @Override
    public void setPublishTriggerNode(Object publishTriggerNode) {
    }

    @Override
    public void setResetTriggerNode(Object resetTriggerNode) {
    }

    @Override
    public void setPublishTriggerOverrideNode(Object publishTriggerOverrideNode) {
    }

    public String toString() {
        return "MergeMapToNodeFlowFunction(result=" + this.result + ", mergeProperties=" + this.mergeProperties + ", triggerList=" + this.triggerList + ", nonTriggeringSources=" + this.nonTriggeringSources + ", requiredSet=" + this.requiredSet + ", allTriggersUpdated=" + this.allTriggersUpdated + ", dirtyStateMonitor=" + this.dirtyStateMonitor + ")";
    }
}

