/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.EventProcessorBuilderService;
import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.PushReference;
import com.fluxtion.runtime.annotations.builder.FluxtionIgnore;
import com.fluxtion.runtime.dataflow.FlowSupplier;
import com.fluxtion.runtime.dataflow.Stateful;
import com.fluxtion.runtime.dataflow.function.BaseFlowNode;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public abstract class MultiArgumentPushFunction<T>
extends BaseFlowNode<T> {
    @PushReference
    protected T pushTarget;
    @FluxtionIgnore
    private final boolean statefulFunction;
    @NoTriggerReference
    protected transient Stateful<?> resetFunction;
    protected final transient String auditInfo;

    MultiArgumentPushFunction(LambdaReflection.MethodReferenceReflection methodReference, FlowSupplier<?> ... flowSuppliers) {
        Objects.requireNonNull(methodReference, "push methodReference cannot be null");
        Objects.requireNonNull(flowSuppliers, "flowSuppliers cannot be null");
        if (methodReference.isDefaultConstructor()) {
            throw new IllegalArgumentException("push methodReference must not be defaultConstructor");
        }
        if (flowSuppliers.length == 0) {
            throw new IllegalArgumentException("flowSuppliers cannot be empty");
        }
        if (methodReference.captured().length == 0) {
            try {
                this.pushTarget = methodReference.getContainingClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("no default constructor found for class:" + methodReference.getContainingClass() + " either add default constructor or pass in a node instance");
            }
        } else {
            this.pushTarget = EventProcessorBuilderService.service().addOrReuse(methodReference.captured()[0]);
        }
        this.statefulFunction = Stateful.class.isAssignableFrom(this.pushTarget.getClass());
        if (this.statefulFunction) {
            this.resetFunction = (Stateful)methodReference.captured()[0];
        }
        for (FlowSupplier<?> flowSupplier : flowSuppliers) {
            this.getInputs().add(flowSupplier);
        }
        this.auditInfo = methodReference.method().getDeclaringClass().getSimpleName() + "->" + methodReference.method().getName();
    }

    @Override
    protected void resetOperation() {
        this.resetFunction.reset();
    }

    @Override
    public T get() {
        return this.pushTarget;
    }

    @Override
    public boolean isStatefulFunction() {
        return this.statefulFunction;
    }
}

