/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.function;

import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.PushReference;
import com.fluxtion.runtime.dataflow.DoubleFlowFunction;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.IntFlowFunction;
import com.fluxtion.runtime.dataflow.LongFlowFunction;
import com.fluxtion.runtime.dataflow.function.AbstractFlowFunction;
import com.fluxtion.runtime.partition.LambdaReflection;

public class PushFlowFunction<T, S extends FlowFunction<T>>
extends AbstractFlowFunction<T, T, S> {
    @PushReference
    private final LambdaReflection.SerializableConsumer<T> eventStreamConsumer;
    private final transient String auditInfo;

    public PushFlowFunction(S inputEventStream, LambdaReflection.SerializableConsumer<T> eventStreamConsumer) {
        super(inputEventStream, null);
        this.eventStreamConsumer = eventStreamConsumer;
        this.auditInfo = eventStreamConsumer.method().getDeclaringClass().getSimpleName() + "->" + eventStreamConsumer.method().getName();
    }

    @OnTrigger
    public boolean push() {
        this.auditLog.info("pushTarget", this.auditInfo);
        if (this.executeUpdate()) {
            this.eventStreamConsumer.accept(this.get());
        }
        return this.fireEventUpdateNotification();
    }

    @Override
    public T get() {
        return this.getInputEventStream().get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PushFlowFunction)) {
            return false;
        }
        PushFlowFunction other = (PushFlowFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LambdaReflection.SerializableConsumer<T> this$eventStreamConsumer = this.eventStreamConsumer;
        LambdaReflection.SerializableConsumer<T> other$eventStreamConsumer = other.eventStreamConsumer;
        return !(this$eventStreamConsumer == null ? other$eventStreamConsumer != null : !this$eventStreamConsumer.equals(other$eventStreamConsumer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PushFlowFunction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        LambdaReflection.SerializableConsumer<T> $eventStreamConsumer = this.eventStreamConsumer;
        result = result * 59 + ($eventStreamConsumer == null ? 43 : $eventStreamConsumer.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PushFlowFunction(eventStreamConsumer=" + this.eventStreamConsumer + ", auditInfo=" + this.auditInfo + ")";
    }

    public static class LongPushFlowFunction
    extends AbstractFlowFunction<Long, Long, LongFlowFunction>
    implements LongFlowFunction {
        @PushReference
        private final LambdaReflection.SerializableLongConsumer intConsumer;
        private final transient String auditInfo;

        public LongPushFlowFunction(LongFlowFunction inputEventStream, LambdaReflection.SerializableLongConsumer intConsumer) {
            super(inputEventStream, null);
            this.intConsumer = intConsumer;
            this.auditInfo = intConsumer.method().getDeclaringClass().getSimpleName() + "->" + intConsumer.method().getName();
        }

        @OnTrigger
        public boolean push() {
            this.auditLog.info("pushTarget", this.auditInfo);
            if (this.executeUpdate()) {
                this.intConsumer.accept(this.getAsLong());
            }
            return this.fireEventUpdateNotification();
        }

        @Override
        public long getAsLong() {
            return ((LongFlowFunction)this.getInputEventStream()).getAsLong();
        }

        @Override
        public Long get() {
            return this.getAsLong();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LongPushFlowFunction)) {
                return false;
            }
            LongPushFlowFunction other = (LongPushFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableLongConsumer this$intConsumer = this.intConsumer;
            LambdaReflection.SerializableLongConsumer other$intConsumer = other.intConsumer;
            return !(this$intConsumer == null ? other$intConsumer != null : !this$intConsumer.equals(other$intConsumer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LongPushFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableLongConsumer $intConsumer = this.intConsumer;
            result = result * 59 + ($intConsumer == null ? 43 : $intConsumer.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "PushFlowFunction.LongPushFlowFunction(intConsumer=" + this.intConsumer + ", auditInfo=" + this.auditInfo + ")";
        }
    }

    public static class DoublePushFlowFunction
    extends AbstractFlowFunction<Double, Double, DoubleFlowFunction>
    implements DoubleFlowFunction {
        @PushReference
        private final LambdaReflection.SerializableDoubleConsumer intConsumer;
        private final transient String auditInfo;

        public DoublePushFlowFunction(DoubleFlowFunction inputEventStream, LambdaReflection.SerializableDoubleConsumer intConsumer) {
            super(inputEventStream, null);
            this.intConsumer = intConsumer;
            this.auditInfo = intConsumer.method().getDeclaringClass().getSimpleName() + "->" + intConsumer.method().getName();
        }

        @OnTrigger
        public boolean push() {
            this.auditLog.info("pushTarget", this.auditInfo);
            if (this.executeUpdate()) {
                this.intConsumer.accept(this.getAsDouble());
            }
            return this.fireEventUpdateNotification();
        }

        @Override
        public double getAsDouble() {
            return ((DoubleFlowFunction)this.getInputEventStream()).getAsDouble();
        }

        @Override
        public Double get() {
            return this.getAsDouble();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DoublePushFlowFunction)) {
                return false;
            }
            DoublePushFlowFunction other = (DoublePushFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableDoubleConsumer this$intConsumer = this.intConsumer;
            LambdaReflection.SerializableDoubleConsumer other$intConsumer = other.intConsumer;
            return !(this$intConsumer == null ? other$intConsumer != null : !this$intConsumer.equals(other$intConsumer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DoublePushFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableDoubleConsumer $intConsumer = this.intConsumer;
            result = result * 59 + ($intConsumer == null ? 43 : $intConsumer.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "PushFlowFunction.DoublePushFlowFunction(intConsumer=" + this.intConsumer + ", auditInfo=" + this.auditInfo + ")";
        }
    }

    public static class IntPushFlowFunction
    extends AbstractFlowFunction<Integer, Integer, IntFlowFunction>
    implements IntFlowFunction {
        @PushReference
        private final LambdaReflection.SerializableIntConsumer intConsumer;
        private final transient String auditInfo;

        public IntPushFlowFunction(IntFlowFunction inputEventStream, LambdaReflection.SerializableIntConsumer intConsumer) {
            super(inputEventStream, null);
            this.intConsumer = intConsumer;
            this.auditInfo = intConsumer.method().getDeclaringClass().getSimpleName() + "->" + intConsumer.method().getName();
        }

        @OnTrigger
        public boolean push() {
            this.auditLog.info("pushTarget", this.auditInfo);
            if (this.executeUpdate()) {
                this.intConsumer.accept(this.getAsInt());
            }
            return this.fireEventUpdateNotification();
        }

        @Override
        public int getAsInt() {
            return ((IntFlowFunction)this.getInputEventStream()).getAsInt();
        }

        @Override
        public Integer get() {
            return this.getAsInt();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IntPushFlowFunction)) {
                return false;
            }
            IntPushFlowFunction other = (IntPushFlowFunction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LambdaReflection.SerializableIntConsumer this$intConsumer = this.intConsumer;
            LambdaReflection.SerializableIntConsumer other$intConsumer = other.intConsumer;
            return !(this$intConsumer == null ? other$intConsumer != null : !this$intConsumer.equals(other$intConsumer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof IntPushFlowFunction;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            LambdaReflection.SerializableIntConsumer $intConsumer = this.intConsumer;
            result = result * 59 + ($intConsumer == null ? 43 : $intConsumer.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "PushFlowFunction.IntPushFlowFunction(intConsumer=" + this.intConsumer + ", auditInfo=" + this.auditInfo + ")";
        }
    }
}

