/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.groupby;

import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.dataflow.Stateful;
import com.fluxtion.runtime.dataflow.aggregate.AggregateFlowFunction;
import com.fluxtion.runtime.dataflow.groupby.GroupBy;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.LongAdder;

public class GroupByFlowFunctionWrapper<T, K, V, A, F extends AggregateFlowFunction<V, A, F>>
implements AggregateFlowFunction<T, GroupBy<K, A>, GroupByFlowFunctionWrapper<T, K, V, A, F>>,
GroupBy<K, A>,
Stateful<GroupBy<K, A>> {
    private final LambdaReflection.SerializableFunction<T, K> keyFunction;
    private final LambdaReflection.SerializableFunction<T, V> valueFunction;
    private final LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier;
    private final transient Map<K, F> mapOfFunctions;
    private final transient Map<K, A> mapOfValues;
    private final transient Map<K, LongAdder> keyCount;
    private F latestAggregateValue;
    private GroupBy.KeyValue<K, A> keyValue;

    public GroupByFlowFunctionWrapper(@AssignToField(value="keyFunction") LambdaReflection.SerializableFunction<T, K> keyFunction, @AssignToField(value="valueFunction") LambdaReflection.SerializableFunction<T, V> valueFunction, @AssignToField(value="aggregateFunctionSupplier") LambdaReflection.SerializableSupplier<F> aggregateFunctionSupplier) {
        this.keyFunction = keyFunction;
        this.valueFunction = valueFunction;
        this.aggregateFunctionSupplier = aggregateFunctionSupplier;
        this.mapOfFunctions = new HashMap<K, F>();
        this.mapOfValues = new HashMap<K, A>();
        this.keyCount = new HashMap<K, LongAdder>();
    }

    @Override
    public GroupBy<K, A> get() {
        return this;
    }

    @Override
    public void combine(GroupByFlowFunctionWrapper<T, K, V, A, F> add) {
        add.mapOfFunctions.forEach((k, f) -> {
            AggregateFlowFunction targetFunction = this.mapOfFunctions.computeIfAbsent(k, key -> (AggregateFlowFunction)this.aggregateFunctionSupplier.get());
            this.keyCount.computeIfAbsent(k, key -> new LongAdder()).increment();
            targetFunction.combine(f);
            this.mapOfValues.put(k, targetFunction.get());
        });
    }

    @Override
    public void deduct(GroupByFlowFunctionWrapper<T, K, V, A, F> add) {
        add.mapOfFunctions.forEach((k, f) -> {
            LongAdder currentCount = this.keyCount.computeIfAbsent(k, key -> new LongAdder());
            currentCount.decrement();
            if (currentCount.intValue() < 1) {
                currentCount.reset();
                this.mapOfFunctions.remove(k);
                this.mapOfValues.remove(k);
            } else {
                AggregateFlowFunction targetFunction = (AggregateFlowFunction)this.mapOfFunctions.get(k);
                targetFunction.deduct(f);
                this.mapOfValues.put(k, targetFunction.get());
            }
        });
    }

    @Override
    public GroupBy<K, A> aggregate(T input) {
        Object key = this.keyFunction.apply(input);
        Object value = this.valueFunction.apply(input);
        AggregateFlowFunction currentFunction = (AggregateFlowFunction)this.mapOfFunctions.get(key);
        if (currentFunction == null) {
            currentFunction = (AggregateFlowFunction)this.aggregateFunctionSupplier.get();
            this.mapOfFunctions.put(key, currentFunction);
            this.keyCount.computeIfAbsent(key, k -> new LongAdder()).increment();
        }
        currentFunction.aggregate(value);
        this.latestAggregateValue = currentFunction;
        this.mapOfValues.put(key, this.latestAggregateValue.get());
        this.keyValue = new GroupBy.KeyValue(key, this.latestAggregateValue.get());
        return this;
    }

    @Override
    public GroupBy.KeyValue<K, A> lastKeyValue() {
        return this.keyValue;
    }

    @Override
    public Map<K, A> toMap() {
        return this.mapOfValues;
    }

    @Override
    public A lastValue() {
        return (A)this.latestAggregateValue.get();
    }

    @Override
    public Collection<A> values() {
        return this.toMap().values();
    }

    @Override
    public GroupBy<K, A> reset() {
        this.mapOfFunctions.clear();
        this.mapOfValues.clear();
        this.keyValue = null;
        return this;
    }

    public String toString() {
        return "GroupByFlowFunctionWrapper{mapOfValues=" + this.mapOfValues + '}';
    }
}

