/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.groupby;

import com.fluxtion.runtime.annotations.NoTriggerReference;
import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.builder.SepNode;
import com.fluxtion.runtime.dataflow.FlowFunction;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.AggregateFlowFunction;
import com.fluxtion.runtime.dataflow.function.AbstractFlowFunction;
import com.fluxtion.runtime.dataflow.groupby.GroupBy;
import com.fluxtion.runtime.dataflow.groupby.GroupByFlowFunctionWrapper;
import com.fluxtion.runtime.partition.LambdaReflection;
import com.fluxtion.runtime.time.FixedRateTrigger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class GroupByTumblingWindow<T, K, V, R, S extends FlowFunction<T>, F extends AggregateFlowFunction<V, R, F>>
extends AbstractFlowFunction<T, GroupBy<K, R>, S>
implements TriggeredFlowFunction<GroupBy<K, R>> {
    @SepNode
    @NoTriggerReference
    public GroupByFlowFunctionWrapper<T, K, V, R, F> groupByWindowedCollection;
    public FixedRateTrigger rollTrigger;
    private final transient Map<K, R> mapOfValues = new HashMap<K, R>();
    private final transient MyGroupBy results = new MyGroupBy();

    public GroupByTumblingWindow(S inputEventStream, LambdaReflection.SerializableSupplier<F> windowFunctionSupplier, LambdaReflection.SerializableFunction<T, K> keyFunction, LambdaReflection.SerializableFunction<T, V> valueFunction, int windowSizeMillis) {
        this(inputEventStream);
        this.groupByWindowedCollection = new GroupByFlowFunctionWrapper(keyFunction, valueFunction, windowFunctionSupplier);
        this.rollTrigger = FixedRateTrigger.atMillis(windowSizeMillis);
    }

    public GroupByTumblingWindow(S inputEventStream) {
        super(inputEventStream, null);
    }

    @Override
    public GroupBy<K, R> get() {
        return this.results;
    }

    protected void cacheWindowValue() {
        this.mapOfValues.clear();
        this.mapOfValues.putAll(this.groupByWindowedCollection.toMap());
    }

    protected void aggregateInputValue(S inputEventStream) {
        this.groupByWindowedCollection.aggregate(inputEventStream.get());
    }

    @OnParentUpdate
    public void timeTriggerFired(FixedRateTrigger rollTrigger) {
        if (rollTrigger.getTriggerCount() == 1) {
            this.cacheWindowValue();
        }
        this.publishOverrideTriggered = !this.overridePublishTrigger & !this.overrideUpdateTrigger;
        this.inputStreamTriggered_1 = true;
        this.inputStreamTriggered = true;
        this.groupByWindowedCollection.reset();
        if (rollTrigger.getTriggerCount() != 1) {
            this.cacheWindowValue();
        }
    }

    @Override
    @OnParentUpdate
    public void inputUpdated(S inputEventStream) {
        this.aggregateInputValue(inputEventStream);
        this.inputStreamTriggered_1 = false;
        this.inputStreamTriggered = false;
    }

    @Override
    @OnParentUpdate(value="updateTriggerNode")
    public void updateTriggerNodeUpdated(Object triggerNode) {
        super.updateTriggerNodeUpdated(triggerNode);
        this.cacheWindowValue();
    }

    @Override
    protected void resetOperation() {
        this.mapOfValues.clear();
        this.groupByWindowedCollection.reset();
    }

    @Override
    public boolean isStatefulFunction() {
        return true;
    }

    @OnTrigger
    public boolean triggered() {
        return this.fireEventUpdateNotification();
    }

    private class MyGroupBy
    implements GroupBy<K, R> {
        private MyGroupBy() {
        }

        @Override
        public Map<K, R> toMap() {
            return GroupByTumblingWindow.this.mapOfValues;
        }

        @Override
        public Collection<R> values() {
            return GroupByTumblingWindow.this.mapOfValues.values();
        }

        @Override
        public R lastValue() {
            return GroupByTumblingWindow.this.groupByWindowedCollection.lastValue();
        }

        @Override
        public GroupBy.KeyValue<K, R> lastKeyValue() {
            return GroupByTumblingWindow.this.groupByWindowedCollection.lastKeyValue();
        }
    }
}

