/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.groupby;

import com.fluxtion.runtime.annotations.OnParentUpdate;
import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.builder.SepNode;
import com.fluxtion.runtime.dataflow.FlowSupplier;
import com.fluxtion.runtime.dataflow.Stateful;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.dataflow.groupby.GroupBy;
import com.fluxtion.runtime.dataflow.groupby.GroupByHashMap;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@SepNode
public class MultiJoin<K, T>
implements TriggeredFlowFunction<GroupBy<K, T>>,
GroupBy<K, T>,
Stateful<GroupBy<K, T>> {
    protected final transient GroupByHashMap<K, T> joinedGroup = new GroupByHashMap();
    private final Class<K> keyClass;
    private final LambdaReflection.SerializableSupplier<T> target;
    private List<LegMapper<T>> legMappers = new ArrayList<LegMapper<T>>();
    private boolean updated;

    public <A, B> MultiJoin<K, T> addJoin(FlowSupplier<GroupBy<A, B>> flow1, LambdaReflection.SerializableBiConsumer<T, B> setter1) {
        return this._addOptionalJoin(flow1, setter1, false);
    }

    public <A, B> MultiJoin<K, T> addOptionalJoin(FlowSupplier<GroupBy<A, B>> flow1, LambdaReflection.SerializableBiConsumer<T, B> setter1) {
        return this._addOptionalJoin(flow1, setter1, true);
    }

    public Class<T> targetClass() {
        return this.target.getContainingClass();
    }

    public Class<K> keyClass() {
        return this.keyClass;
    }

    @OnParentUpdate
    public void groupByUpdated(LegMapper<T> legMapperUpdated) {
        FlowSupplier aflow = ((LegMapper)legMapperUpdated).flow;
        GroupBy.KeyValue keyValue = ((GroupBy)aflow.get()).lastKeyValue();
        Object key = keyValue.getKey();
        Object target = this.target.get();
        this.updated = true;
        int legMappersSize = this.legMappers.size();
        for (int i = 0; i < legMappersSize; ++i) {
            LegMapper legMapper = this.legMappers.get(i);
            if (legMapper.flow.get() == null || ((GroupBy)legMapper.flow.get()).toMap().get(key) == null) {
                if (legMapper.optional) continue;
                this.updated = false;
                this.joinedGroup.toMap().remove(key);
                return;
            }
            Object value = ((GroupBy)legMapper.flow.get()).toMap().get(key);
            legMapper.updateTarget(target, value);
        }
        this.joinedGroup.toMap().put(key, target);
    }

    @OnTrigger
    public boolean updated() {
        boolean tempUpdateFLag = this.updated;
        this.updated = false;
        return tempUpdateFLag;
    }

    public <A, B> MultiJoin<K, T> _addOptionalJoin(FlowSupplier<GroupBy<A, B>> flow1, LambdaReflection.SerializableBiConsumer<T, B> setter1, boolean optional) {
        LegMapper<T> legMapper = new LegMapper<T>();
        legMapper.setFlow(flow1);
        legMapper.setSetter(setter1);
        legMapper.setOptional(optional);
        this.legMappers.add(legMapper);
        return this;
    }

    @Override
    public void setUpdateTriggerNode(Object updateTriggerNode) {
    }

    @Override
    public void setPublishTriggerNode(Object publishTriggerNode) {
    }

    @Override
    public void setResetTriggerNode(Object resetTriggerNode) {
    }

    @Override
    public void setPublishTriggerOverrideNode(Object publishTriggerOverrideNode) {
    }

    @Override
    public boolean hasChanged() {
        return this.updated;
    }

    @Override
    public void parallel() {
    }

    @Override
    public boolean parallelCandidate() {
        return false;
    }

    @Override
    public GroupBy<K, T> get() {
        return this.joinedGroup;
    }

    @Override
    public Map<K, T> toMap() {
        return this.joinedGroup.toMap();
    }

    @Override
    public Collection<T> values() {
        return this.joinedGroup.values();
    }

    @Override
    public T lastValue() {
        return (T)this.joinedGroup.lastValue();
    }

    @Override
    public GroupBy.KeyValue<K, T> lastKeyValue() {
        return this.joinedGroup.lastKeyValue();
    }

    @Override
    public GroupBy<K, T> reset() {
        this.joinedGroup.reset();
        return this.joinedGroup;
    }

    public MultiJoin(Class<K> keyClass, LambdaReflection.SerializableSupplier<T> target) {
        this.keyClass = keyClass;
        this.target = target;
    }

    public Class<K> getKeyClass() {
        return this.keyClass;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public void setLegMappers(List<LegMapper<T>> legMappers) {
        this.legMappers = legMappers;
    }

    public List<LegMapper<T>> getLegMappers() {
        return this.legMappers;
    }

    @SepNode
    public static class LegMapper<T> {
        private FlowSupplier<GroupBy<Object, Object>> flow;
        private LambdaReflection.SerializableBiConsumer<T, Object> setter;
        private boolean optional = false;

        public <A, B> void setFlow(FlowSupplier<GroupBy<A, B>> flow1) {
            this.flow = flow1;
        }

        public <R> void setSetter(LambdaReflection.SerializableBiConsumer<T, R> setter1) {
            this.setter = setter1;
        }

        public <R> void updateTarget(T target, R value) {
            this.setter.accept(target, value);
        }

        public Class<T> targetClass() {
            return this.setter.getContainingClass();
        }

        @OnTrigger
        public boolean groupByUpdated() {
            return true;
        }

        public FlowSupplier<GroupBy<Object, Object>> getFlow() {
            return this.flow;
        }

        public LambdaReflection.SerializableBiConsumer<T, Object> getSetter() {
            return this.setter;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public void setOptional(boolean optional) {
            this.optional = optional;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LegMapper)) {
                return false;
            }
            LegMapper other = (LegMapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isOptional() != other.isOptional()) {
                return false;
            }
            FlowSupplier<GroupBy<Object, Object>> this$flow = this.getFlow();
            FlowSupplier<GroupBy<Object, Object>> other$flow = other.getFlow();
            if (this$flow == null ? other$flow != null : !this$flow.equals(other$flow)) {
                return false;
            }
            LambdaReflection.SerializableBiConsumer<T, Object> this$setter = this.getSetter();
            LambdaReflection.SerializableBiConsumer<T, Object> other$setter = other.getSetter();
            return !(this$setter == null ? other$setter != null : !this$setter.equals(other$setter));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LegMapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOptional() ? 79 : 97);
            FlowSupplier<GroupBy<Object, Object>> $flow = this.getFlow();
            result = result * 59 + ($flow == null ? 43 : $flow.hashCode());
            LambdaReflection.SerializableBiConsumer<T, Object> $setter = this.getSetter();
            result = result * 59 + ($setter == null ? 43 : $setter.hashCode());
            return result;
        }

        public String toString() {
            return "MultiJoin.LegMapper(flow=" + this.getFlow() + ", setter=" + this.getSetter() + ", optional=" + this.isOptional() + ")";
        }
    }
}

