/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.groupby;

import com.fluxtion.runtime.dataflow.Tuple;
import com.fluxtion.runtime.util.ObjectPool;

public class MutableTuple<F, S>
implements Tuple<F, S> {
    private F first;
    private S second;

    public MutableTuple(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public MutableTuple() {
    }

    @Override
    public F getFirst() {
        return this.first;
    }

    @Override
    public S getSecond() {
        return this.second;
    }

    public MutableTuple<F, S> setFirst(F first) {
        this.first = first;
        return this;
    }

    public MutableTuple<F, S> setSecond(S second) {
        this.second = second;
        return this;
    }

    public void returnToPool(ObjectPool objectPool) {
        this.setFirst(null);
        this.setSecond(null);
        objectPool.checkIn(this);
    }

    public String toString() {
        return "MutableTuple(first=" + this.getFirst() + ", second=" + this.getSecond() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MutableTuple)) {
            return false;
        }
        MutableTuple other = (MutableTuple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        F this$first = this.getFirst();
        F other$first = other.getFirst();
        if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
            return false;
        }
        S this$second = this.getSecond();
        S other$second = other.getSecond();
        return !(this$second == null ? other$second != null : !this$second.equals(other$second));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MutableTuple;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        F $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : $first.hashCode());
        S $second = this.getSecond();
        result = result * 59 + ($second == null ? 43 : $second.hashCode());
        return result;
    }
}

