/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.helpers;

import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.dataflow.Stateful;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.CountFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.DoubleAverageFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.DoubleMaxFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.DoubleMinFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.DoubleSumFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.IntAverageFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.IntMaxFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.IntMinFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.IntSumFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.LongAverageFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.LongMaxFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.LongMinFlowFunction;
import com.fluxtion.runtime.dataflow.aggregate.function.primitive.LongSumFlowFunction;
import com.fluxtion.runtime.dataflow.groupby.GroupBy;
import com.fluxtion.runtime.dataflow.groupby.TopNByValue;
import com.fluxtion.runtime.dataflow.helpers.Aggregates;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.util.List;
import java.util.Map;

public interface Mappers {
    public static final LambdaReflection.SerializableBiIntFunction ADD_INTS = Mappers::addInts;
    public static final LambdaReflection.SerializableBiDoubleFunction ADD_DOUBLES = Mappers::addDoubles;
    public static final LambdaReflection.SerializableBiLongFunction ADD_LONGS = Mappers::addLongs;
    public static final LambdaReflection.SerializableBiIntFunction SUBTRACT_INTS = Mappers::subtractInts;
    public static final LambdaReflection.SerializableBiDoubleFunction SUBTRACT_DOUBLES = Mappers::subtractDoubles;
    public static final LambdaReflection.SerializableBiLongFunction SUBTRACT_LONGS = Mappers::subtractLongs;
    public static final LambdaReflection.SerializableBiIntFunction MULTIPLY_INTS = Mappers::multiplyInts;
    public static final LambdaReflection.SerializableBiDoubleFunction MULTIPLY_DOUBLES = Mappers::multiplyDoubles;
    public static final LambdaReflection.SerializableBiLongFunction MULTIPLY_LONGS = Mappers::multiplyLongs;
    public static final LambdaReflection.SerializableBiIntFunction DIVIDE_INTS = Mappers::divideInts;
    public static final LambdaReflection.SerializableBiLongFunction DIVIDE_LONGS = Mappers::divideLongs;
    public static final LambdaReflection.SerializableBiDoubleFunction DIVIDE_DOUBLES = Mappers::divideDoubles;

    public static <T> T identity(T in) {
        return in;
    }

    public static <T, R> R cast(T in) {
        return (R)in;
    }

    public static double nanToZero(double in) {
        return Double.isNaN(in) ? 0.0 : in;
    }

    public static <T> LambdaReflection.SerializableToIntFunction<T> count() {
        return ((CountFlowFunction)Aggregates.countFactory().get())::aggregate;
    }

    public static LambdaReflection.SerializableIntUnaryOperator countInt() {
        return ((CountFlowFunction)Aggregates.countFactory().get())::increment;
    }

    public static LambdaReflection.SerializableLongUnaryOperator countLong() {
        return ((CountFlowFunction)Aggregates.countFactory().get())::increment;
    }

    public static LambdaReflection.SerializableDoubleUnaryOperator countDouble() {
        return ((CountFlowFunction)Aggregates.countFactory().get())::increment;
    }

    public static LambdaReflection.SerializableIntUnaryOperator cumSumInt() {
        return ((IntSumFlowFunction)Aggregates.intSumFactory().get())::aggregateInt;
    }

    public static LambdaReflection.SerializableDoubleUnaryOperator cumSumDouble() {
        return ((DoubleSumFlowFunction)Aggregates.doubleSumFactory().get())::aggregateDouble;
    }

    public static LambdaReflection.SerializableLongUnaryOperator cumSumLong() {
        return ((LongSumFlowFunction)Aggregates.longSumFactory().get())::aggregateLong;
    }

    public static LambdaReflection.SerializableIntUnaryOperator minimumInt() {
        return ((IntMinFlowFunction)Aggregates.intMinFactory().get())::aggregateInt;
    }

    public static LambdaReflection.SerializableDoubleUnaryOperator minimumDouble() {
        return ((DoubleMinFlowFunction)Aggregates.doubleMinFactory().get())::aggregateDouble;
    }

    public static LambdaReflection.SerializableLongUnaryOperator minimumLong() {
        return ((LongMinFlowFunction)Aggregates.longMinFactory().get())::aggregateLong;
    }

    public static LambdaReflection.SerializableIntUnaryOperator maximumInt() {
        return ((IntMaxFlowFunction)Aggregates.intMaxFactory().get())::aggregateInt;
    }

    public static LambdaReflection.SerializableDoubleUnaryOperator maximumDouble() {
        return ((DoubleMaxFlowFunction)Aggregates.doubleMaxFactory().get())::aggregateDouble;
    }

    public static LambdaReflection.SerializableLongUnaryOperator maximumLong() {
        return ((LongMaxFlowFunction)Aggregates.longMaxFactory().get())::aggregateLong;
    }

    public static LambdaReflection.SerializableIntUnaryOperator averageInt() {
        return ((IntAverageFlowFunction)Aggregates.intAverageFactory().get())::aggregateInt;
    }

    public static LambdaReflection.SerializableDoubleUnaryOperator averageDouble() {
        return ((DoubleAverageFlowFunction)Aggregates.doubleAverageFactory().get())::aggregateDouble;
    }

    public static LambdaReflection.SerializableLongUnaryOperator averageLong() {
        return ((LongAverageFlowFunction)Aggregates.longAverageFactory().get())::aggregateLong;
    }

    public static CountNode newCountNode() {
        return new CountNode();
    }

    public static int parseInt(String input) {
        return Integer.parseInt(input);
    }

    public static double parseDouble(String input) {
        return Double.parseDouble(input);
    }

    public static long parseLong(String input) {
        return Long.parseLong(input);
    }

    public static <K, V extends Comparable<V>> LambdaReflection.SerializableFunction<GroupBy<K, V>, List<Map.Entry<K, V>>> topNByValue(int count) {
        return new TopNByValue(count)::filter;
    }

    public static <K, V, T extends Comparable<T>> LambdaReflection.SerializableFunction<GroupBy<K, V>, List<Map.Entry<K, V>>> topNByValue(int count, LambdaReflection.SerializableFunction<V, T> propertyAccessor) {
        TopNByValue topNByValue = new TopNByValue(count);
        topNByValue.comparing = propertyAccessor;
        return topNByValue::filter;
    }

    public static int addInts(int a, int b) {
        return a + b;
    }

    public static double addDoubles(double a, double b) {
        return a + b;
    }

    public static long addLongs(long a, long b) {
        return a + b;
    }

    public static int subtractInts(int a, int b) {
        return a - b;
    }

    public static double subtractDoubles(double a, double b) {
        return a - b;
    }

    public static long subtractLongs(long a, long b) {
        return a - b;
    }

    public static int multiplyInts(int a, int b) {
        return a * b;
    }

    public static double multiplyDoubles(double a, double b) {
        return a * b;
    }

    public static long multiplyLongs(long a, long b) {
        return a * b;
    }

    public static int divideInts(int a, int b) {
        return a / b;
    }

    public static double divideDoubles(double a, double b) {
        return a / b;
    }

    public static long divideLongs(long a, long b) {
        return a / b;
    }

    public static double int2Double(int in) {
        return in;
    }

    public static long int2Long(int in) {
        return in;
    }

    public static double long2Double(long in) {
        return in;
    }

    public static int long2Int(long in) {
        return (int)in;
    }

    public static int double2Int(double in) {
        return (int)in;
    }

    public static long double2Long(double in) {
        return (long)in;
    }

    public static class CountNode
    implements Stateful<Integer> {
        int count;

        @OnTrigger
        public boolean increment() {
            ++this.count;
            return true;
        }

        public int getCount() {
            return this.count;
        }

        @Override
        public Integer reset() {
            this.count = 0;
            return this.count;
        }

        public String toString() {
            return "Mappers.CountNode(count=" + this.getCount() + ")";
        }
    }
}

