/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.dataflow.helpers;

import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.dataflow.Tuple;
import com.fluxtion.runtime.partition.LambdaReflection;

public class Tuples {
    public static <F, S, TIN extends Tuple<? extends F, ? extends S>> LambdaReflection.SerializableFunction<TIN, Tuple<F, S>> replaceNull(F first, S second) {
        return new ReplaceNull<F, S>(first, second)::replaceNull;
    }

    public static <F, S, R, T extends Tuple<F, S>> LambdaReflection.SerializableFunction<T, R> mapTuple(LambdaReflection.SerializableBiFunction<F, S, R> tupleMapFunction) {
        return new MapTuple<F, S, R>(tupleMapFunction)::mapTuple;
    }

    public static final class MapTuple<F, S, R> {
        private final LambdaReflection.SerializableBiFunction<F, S, R> tupleMapFunction;

        public R mapTuple(Tuple<? extends F, ? extends S> tuple) {
            return this.tupleMapFunction.apply(tuple.getFirst(), tuple.getSecond());
        }

        public MapTuple(LambdaReflection.SerializableBiFunction<F, S, R> tupleMapFunction) {
            this.tupleMapFunction = tupleMapFunction;
        }

        public LambdaReflection.SerializableBiFunction<F, S, R> getTupleMapFunction() {
            return this.tupleMapFunction;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapTuple)) {
                return false;
            }
            MapTuple other = (MapTuple)o;
            LambdaReflection.SerializableBiFunction<F, S, R> this$tupleMapFunction = this.getTupleMapFunction();
            LambdaReflection.SerializableBiFunction<F, S, R> other$tupleMapFunction = other.getTupleMapFunction();
            return !(this$tupleMapFunction == null ? other$tupleMapFunction != null : !this$tupleMapFunction.equals(other$tupleMapFunction));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LambdaReflection.SerializableBiFunction<F, S, R> $tupleMapFunction = this.getTupleMapFunction();
            result = result * 59 + ($tupleMapFunction == null ? 43 : $tupleMapFunction.hashCode());
            return result;
        }

        public String toString() {
            return "Tuples.MapTuple(tupleMapFunction=" + this.getTupleMapFunction() + ")";
        }
    }

    public static class ReplaceNull<F, S> {
        private final F firstValue;
        private final S secondValue;

        public ReplaceNull(@AssignToField(value="firstValue") F firstValue, @AssignToField(value="secondValue") S secondValue) {
            this.firstValue = firstValue;
            this.secondValue = secondValue;
        }

        public Tuple<F, S> replaceNull(Tuple<? extends F, ? extends S> in) {
            F first = in.getFirst() == null ? this.firstValue : in.getFirst();
            S second = in.getSecond() == null ? this.secondValue : in.getSecond();
            return Tuple.build(first, second);
        }
    }
}

