/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.event;

import com.fluxtion.runtime.event.DefaultEvent;
import com.fluxtion.runtime.event.Event;

public class Signal<T>
implements Event {
    private String filterString;
    private T value;

    public Signal() {
    }

    public Signal(String filterString) {
        this(filterString, null);
    }

    public Signal(Enum<?> enumFilter) {
        this(enumFilter.name());
    }

    public Signal(String filterString, T value) {
        this.filterString = filterString;
        this.value = value;
    }

    public Signal(T value) {
        this.filterString = value.getClass().getCanonicalName();
        this.value = value;
    }

    public Signal(Class filterClass, T value) {
        this.filterString = filterClass.getCanonicalName();
        this.value = value;
    }

    public static IntSignal intSignal(String filter, int value) {
        return new IntSignal(filter, value);
    }

    public static DoubleSignal doubleSignal(String filter, double value) {
        return new DoubleSignal(filter, value);
    }

    public static LongSignal longSignal(String filter, long value) {
        return new LongSignal(filter, value);
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    @Override
    public String filterString() {
        return this.filterString;
    }

    public String toString() {
        return "Signal: {filterString: " + this.filterString + ", value: " + this.value + '}';
    }

    public static class LongSignal
    extends DefaultEvent {
        private final long value;

        public LongSignal(String filterId, long intValue) {
            super(filterId);
            this.value = intValue;
        }

        public long getValue() {
            return this.value;
        }
    }

    public static class DoubleSignal
    extends DefaultEvent {
        private final double value;

        public DoubleSignal(String filterId, double intValue) {
            super(filterId);
            this.value = intValue;
        }

        public double getValue() {
            return this.value;
        }
    }

    public static class IntSignal
    extends DefaultEvent {
        private final int value;

        public IntSignal(String filterId, int value) {
            super(filterId);
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

