/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.input;

import com.fluxtion.runtime.StaticEventProcessor;
import com.fluxtion.runtime.annotations.TearDown;
import com.fluxtion.runtime.annotations.builder.FluxtionIgnore;
import com.fluxtion.runtime.annotations.runtime.ServiceDeregistered;
import com.fluxtion.runtime.annotations.runtime.ServiceRegistered;
import com.fluxtion.runtime.event.NamedFeedEvent;
import com.fluxtion.runtime.input.EventFeed;
import com.fluxtion.runtime.input.NamedFeed;
import com.fluxtion.runtime.input.SubscriptionManager;
import com.fluxtion.runtime.node.EventSubscription;
import com.fluxtion.runtime.node.NamedNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SubscriptionManagerNode
implements SubscriptionManager,
NamedNode {
    private final transient List<EventFeed> registeredFeeds = new ArrayList<EventFeed>();
    private final transient Map<String, NamedFeed> registeredNameEventFeedMap = new HashMap<String, NamedFeed>();
    private final transient Map<Object, Integer> subscriptionMap = new HashMap<Object, Integer>();
    private final transient Map<EventSubscription<?>, Integer> namedFeedSubscriptionMap = new HashMap();
    @FluxtionIgnore
    private StaticEventProcessor eventProcessor = StaticEventProcessor.NULL_EVENTHANDLER;

    public void setSubscribingEventProcessor(StaticEventProcessor eventProcessor) {
        this.eventProcessor = eventProcessor;
    }

    public void addEventProcessorFeed(EventFeed eventFeed) {
        if (!this.registeredFeeds.contains(eventFeed)) {
            eventFeed.registerSubscriber(this.eventProcessor);
            this.registeredFeeds.add(eventFeed);
            this.subscriptionMap.keySet().forEach(e -> eventFeed.subscribe(this.eventProcessor, e));
        }
    }

    public void removeEventProcessorFeed(EventFeed eventProcessorFeed) {
        this.registeredFeeds.remove(eventProcessorFeed);
    }

    @Override
    public void subscribe(Object subscriptionId) {
        this.subscriptionMap.compute(subscriptionId, (k, v) -> {
            if (v == null) {
                this.registeredFeeds.forEach(e -> e.subscribe(this.eventProcessor, subscriptionId));
                return 1;
            }
            v = v + 1;
            return v;
        });
    }

    @Override
    public void unSubscribe(Object subscriptionId) {
        this.subscriptionMap.computeIfPresent(subscriptionId, (o, i) -> {
            if ((i = Integer.valueOf(i - 1)) < 1) {
                this.registeredFeeds.forEach(e -> e.unSubscribe(this.eventProcessor, subscriptionId));
                return null;
            }
            return i;
        });
    }

    @ServiceRegistered
    public void registerEventFeedService(NamedFeed eventFeed, String feedName) {
        if (!this.registeredNameEventFeedMap.containsKey(feedName)) {
            eventFeed.registerSubscriber(this.eventProcessor);
            this.registeredNameEventFeedMap.put(feedName, eventFeed);
            this.namedFeedSubscriptionMap.keySet().forEach(e -> eventFeed.subscribe(this.eventProcessor, e));
        }
    }

    @ServiceDeregistered
    public void deRegisterEventFeedService(NamedFeed eventFeed, String feedName) {
        this.registeredNameEventFeedMap.remove(feedName);
    }

    @Override
    public void subscribeToNamedFeed(EventSubscription<?> subscription) {
        this.namedFeedSubscriptionMap.compute(subscription, (k, v) -> {
            if (v == null) {
                this.registeredNameEventFeedMap.values().forEach(e -> e.subscribe(this.eventProcessor, subscription));
                return 1;
            }
            v = v + 1;
            return v;
        });
    }

    @Override
    public void subscribeToNamedFeed(String feedName) {
        this.subscribeToNamedFeed(new EventSubscription<NamedFeedEvent>(feedName, Integer.MAX_VALUE, feedName, NamedFeedEvent.class));
    }

    @Override
    public void unSubscribeToNamedFeed(EventSubscription<?> subscription) {
        this.namedFeedSubscriptionMap.computeIfPresent(subscription, (k, i) -> {
            if ((i = Integer.valueOf(i - 1)) < 1) {
                this.registeredNameEventFeedMap.values().forEach(e -> e.unSubscribe(this.eventProcessor, subscription));
                return 1;
            }
            return i;
        });
    }

    @Override
    public void unSubscribeToNamedFeed(String feedName) {
        this.unSubscribeToNamedFeed(new EventSubscription<NamedFeedEvent>(feedName, Integer.MAX_VALUE, feedName, NamedFeedEvent.class));
    }

    @TearDown
    public void tearDown() {
        this.registeredFeeds.forEach(e -> e.removeAllSubscriptions(this.eventProcessor));
        this.subscriptionMap.clear();
        this.registeredNameEventFeedMap.values().forEach(e -> e.removeAllSubscriptions(this.eventProcessor));
        this.namedFeedSubscriptionMap.clear();
    }

    @Override
    public String getName() {
        return "subscriptionManager";
    }
}

