/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.ml;

import com.fluxtion.runtime.annotations.OnTrigger;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.dataflow.FlowSupplier;
import com.fluxtion.runtime.ml.AbstractFeature;
import com.fluxtion.runtime.ml.CalibrationProcessor;

public abstract class FlowSuppliedFeature<T>
extends AbstractFeature
implements CalibrationProcessor {
    protected final FlowSupplier<T> dataFlowSupplier;

    public FlowSuppliedFeature(FlowSupplier<T> dataFlowSupplier) {
        this.dataFlowSupplier = dataFlowSupplier;
    }

    public FlowSuppliedFeature(@AssignToField(value="name") String name, @AssignToField(value="identifier") String identifier, FlowSupplier<T> dataFlowSupplier) {
        super(name, identifier);
        this.dataFlowSupplier = dataFlowSupplier;
    }

    @OnTrigger
    public boolean calculateFeature() {
        double newValue = this.extractFeatureValue() * this.co_efficient * this.weight;
        boolean changed = newValue != this.value;
        this.value = newValue;
        return changed;
    }

    public abstract double extractFeatureValue();

    protected T data() {
        return this.dataFlowSupplier.get();
    }
}

