/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.node;

import com.fluxtion.runtime.EventProcessorContext;
import com.fluxtion.runtime.annotations.Initialise;
import com.fluxtion.runtime.annotations.TearDown;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.audit.EventLogNode;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.lifecycle.Lifecycle;
import com.fluxtion.runtime.node.EventHandlerNode;
import com.fluxtion.runtime.node.NamedNode;
import java.util.Objects;
import java.util.function.BooleanSupplier;

public final class DefaultEventHandlerNode<T>
extends EventLogNode
implements Lifecycle,
NamedNode,
EventHandlerNode<T>,
TriggeredFlowFunction<T> {
    private final int filterId;
    private final String filterString;
    private final Class<T> eventClass;
    private final String name;
    private T event;
    private BooleanSupplier dirtySupplier;
    @Inject
    private final EventProcessorContext eventProcessorContext;

    public DefaultEventHandlerNode(Class<T> eventClass) {
        this(Integer.MAX_VALUE, "", eventClass);
    }

    public DefaultEventHandlerNode(int filterId, Class<T> eventClass) {
        this(filterId, "", eventClass);
    }

    public DefaultEventHandlerNode(String filterString, Class<T> eventClass) {
        this(Integer.MAX_VALUE, filterString, eventClass);
    }

    public DefaultEventHandlerNode(int filterId, String filterString, Class<T> eventClass) {
        this.filterId = filterId;
        this.filterString = filterString;
        this.eventClass = eventClass;
        this.name = filterId != Integer.MAX_VALUE ? "handler" + eventClass.getSimpleName() + "_" + filterId : (!filterString.equals("") ? "handler" + eventClass.getSimpleName() + "_" + filterString : "handler" + eventClass.getSimpleName());
        this.eventProcessorContext = null;
    }

    public DefaultEventHandlerNode(int filterId, @AssignToField(value="filterString") String filterString, Class<T> eventClass, @AssignToField(value="name") String name, EventProcessorContext eventProcessorContext) {
        this.eventProcessorContext = eventProcessorContext;
        this.filterId = filterId;
        this.filterString = filterString;
        this.eventClass = eventClass;
        this.name = name;
    }

    @Override
    public void parallel() {
    }

    @Override
    public boolean parallelCandidate() {
        return false;
    }

    @Override
    public int filterId() {
        return this.filterId;
    }

    @Override
    public <E extends T> boolean onEvent(E e) {
        this.auditLog.info("inputEvent", e.getClass().getSimpleName());
        this.event = e;
        return true;
    }

    @Override
    public String filterString() {
        return this.filterString;
    }

    @Override
    public Class<T> eventClass() {
        return this.eventClass;
    }

    @Override
    public boolean hasChanged() {
        return this.dirtySupplier.getAsBoolean();
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + this.filterId;
        hash = 13 * hash + Objects.hashCode(this.eventClass);
        hash = 13 * hash + Objects.hashCode(this.filterString);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultEventHandlerNode other = (DefaultEventHandlerNode)obj;
        if (this.filterId != other.filterId) {
            return false;
        }
        if (this.filterString != other.filterString) {
            return false;
        }
        return Objects.equals(this.eventClass, other.eventClass);
    }

    @Override
    @Initialise
    public void init() {
        this.dirtySupplier = this.eventProcessorContext.getDirtyStateMonitor().dirtySupplier(this);
    }

    @Override
    @TearDown
    public void tearDown() {
    }

    @Override
    public T get() {
        return this.event;
    }

    @Override
    public void setUpdateTriggerNode(Object updateTriggerNode) {
    }

    @Override
    public void setPublishTriggerNode(Object publishTriggerNode) {
    }

    @Override
    public void setResetTriggerNode(Object resetTriggerNode) {
    }

    @Override
    public void setPublishTriggerOverrideNode(Object publishTriggerOverrideNode) {
    }

    @Override
    public String getName() {
        return this.name;
    }
}

