/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.node;

import com.fluxtion.runtime.EventProcessorContext;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.annotations.builder.Inject;
import com.fluxtion.runtime.callback.CallbackDispatcher;
import com.fluxtion.runtime.callback.DirtyStateMonitor;
import com.fluxtion.runtime.callback.EventDispatcher;
import com.fluxtion.runtime.callback.EventProcessorCallbackInternal;
import com.fluxtion.runtime.callback.InternalEventProcessor;
import com.fluxtion.runtime.input.SubscriptionManager;
import com.fluxtion.runtime.node.NamedNode;
import com.fluxtion.runtime.node.NodeNameLookup;
import com.fluxtion.runtime.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class MutableEventProcessorContext
implements EventProcessorContext,
NamedNode {
    private final transient Map<Object, Object> map = new HashMap<Object, Object>();
    @Inject
    private final NodeNameLookup nodeNameLookup;
    @Inject
    private final EventProcessorCallbackInternal eventDispatcher;
    @Inject
    private final SubscriptionManager subscriptionManager;
    @Inject
    private final DirtyStateMonitor dirtyStateMonitor;
    private Clock clock = Clock.DEFAULT_CLOCK;
    private InternalEventProcessor eventProcessorCallback;

    public MutableEventProcessorContext(@AssignToField(value="nodeNameLookup") NodeNameLookup nodeNameLookup, @AssignToField(value="eventDispatcher") EventProcessorCallbackInternal eventDispatcher, @AssignToField(value="subscriptionManager") SubscriptionManager subscriptionManager, @AssignToField(value="dirtyStateMonitor") DirtyStateMonitor dirtyStateMonitor) {
        this.nodeNameLookup = nodeNameLookup;
        this.eventDispatcher = eventDispatcher;
        this.subscriptionManager = subscriptionManager;
        this.dirtyStateMonitor = dirtyStateMonitor;
    }

    public MutableEventProcessorContext() {
        this(null, null, null, null);
    }

    public void replaceMappings(Map<Object, Object> newMap) {
        if (newMap != null) {
            this.map.clear();
            this.map.putAll(newMap);
        }
    }

    public <K, V> void addMapping(K key, V value) {
        this.map.put(key, value);
    }

    public void setEventProcessorCallback(InternalEventProcessor eventProcessorCallback) {
        this.eventProcessorCallback = eventProcessorCallback;
        this.eventDispatcher.setEventProcessor(eventProcessorCallback);
    }

    @Override
    public NodeNameLookup getNodeNameLookup() {
        return this.nodeNameLookup;
    }

    @Override
    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public CallbackDispatcher getCallBackDispatcher() {
        return this.eventDispatcher;
    }

    @Override
    public DirtyStateMonitor getDirtyStateMonitor() {
        return this.dirtyStateMonitor;
    }

    @Override
    public SubscriptionManager getSubscriptionManager() {
        return this.subscriptionManager;
    }

    public Map<Object, Object> getMap() {
        return this.map;
    }

    public <K, V> V put(K key, V value) {
        return (V)this.map.put(key, value);
    }

    @Override
    public <T> T getExportedService(Class<T> exportedServiceClass) {
        return this.eventProcessorCallback.exportedService(exportedServiceClass);
    }

    @Override
    public <T> T getExportedService() {
        return this.eventProcessorCallback.exportedService();
    }

    @Override
    public <T> T getInjectedInstance(Class<T> instanceClass) {
        return (T)Objects.requireNonNull(this.getContextProperty(instanceClass.getCanonicalName()), "no instance injected into context of type:" + instanceClass);
    }

    @Override
    public <T> T getInjectedInstance(Class<T> instanceClass, String name) {
        return (T)Objects.requireNonNull(this.getContextProperty(instanceClass.getCanonicalName() + "_" + name), "no instance injected into context of type:" + instanceClass + " named:" + name);
    }

    @Override
    public <T> T getInjectedInstanceAllowNull(Class<T> instanceClass) {
        return (T)this.getContextProperty(instanceClass.getCanonicalName());
    }

    @Override
    public <T> T getInjectedInstanceAllowNull(Class<T> instanceClass, String name) {
        return (T)this.getContextProperty(instanceClass.getCanonicalName() + "_" + name);
    }

    @Override
    public <K, V> V getContextProperty(K key) {
        return (V)this.map.get(key);
    }

    public String toString() {
        return "MutableEventProcessorContext{map=" + this.map + '}';
    }

    @Override
    public String getName() {
        return "context";
    }

    @Override
    public Clock getClock() {
        return this.clock;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }
}

