/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.node;

import com.fluxtion.runtime.EventProcessorContext;
import com.fluxtion.runtime.EventProcessorContextListener;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.annotations.builder.FluxtionIgnore;
import com.fluxtion.runtime.audit.EventLogNode;
import com.fluxtion.runtime.dataflow.TriggeredFlowFunction;
import com.fluxtion.runtime.event.NamedFeedEvent;
import com.fluxtion.runtime.node.EventHandlerNode;
import com.fluxtion.runtime.node.EventSubscription;
import com.fluxtion.runtime.node.LifecycleNode;
import com.fluxtion.runtime.node.NamedNode;
import java.util.Objects;
import java.util.function.BooleanSupplier;

public class NamedFeedEventHandlerNode<T>
extends EventLogNode
implements LifecycleNode,
NamedNode,
EventProcessorContextListener,
EventHandlerNode<NamedFeedEvent<?>>,
TriggeredFlowFunction<NamedFeedEvent<T>> {
    protected final String feedName;
    @FluxtionIgnore
    protected final String name;
    @FluxtionIgnore
    private final EventSubscription<?> subscription;
    protected NamedFeedEvent<T> feedEvent;
    private BooleanSupplier dirtySupplier;
    private EventProcessorContext currentContext;

    public NamedFeedEventHandlerNode(@AssignToField(value="feedName") String feedName) {
        this(feedName, "eventFeedHandler_" + feedName);
    }

    public NamedFeedEventHandlerNode(@AssignToField(value="feedName") String feedName, @AssignToField(value="name") String name) {
        Objects.requireNonNull(feedName, "feedName cannot be null");
        Objects.requireNonNull(name, "name cannot be null");
        this.feedName = feedName;
        this.name = name;
        this.subscription = new EventSubscription<NamedFeedEvent>(feedName, Integer.MAX_VALUE, feedName, NamedFeedEvent.class);
    }

    @Override
    public void currentContext(EventProcessorContext currentContext) {
        this.currentContext = currentContext;
    }

    @Override
    public void init() {
        this.dirtySupplier = this.currentContext.getDirtyStateMonitor().dirtySupplier(this);
        this.currentContext.getSubscriptionManager().subscribeToNamedFeed(this.subscription);
    }

    @Override
    public void tearDown() {
        this.currentContext.getSubscriptionManager().unSubscribeToNamedFeed(this.subscription);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String filterString() {
        return this.feedName;
    }

    @Override
    public Class<? extends NamedFeedEvent<?>> eventClass() {
        return NamedFeedEvent.class;
    }

    @Override
    public <E extends NamedFeedEvent<?>> boolean onEvent(E e) {
        this.feedEvent = e;
        return true;
    }

    @Override
    public void setUpdateTriggerNode(Object updateTriggerNode) {
    }

    @Override
    public void setPublishTriggerNode(Object publishTriggerNode) {
    }

    @Override
    public void setResetTriggerNode(Object resetTriggerNode) {
    }

    @Override
    public void setPublishTriggerOverrideNode(Object publishTriggerOverrideNode) {
    }

    @Override
    public boolean hasChanged() {
        return this.dirtySupplier.getAsBoolean();
    }

    @Override
    public void parallel() {
    }

    @Override
    public boolean parallelCandidate() {
        return false;
    }

    @Override
    public NamedFeedEvent<T> get() {
        return this.feedEvent;
    }

    public NamedFeedEvent<T> getFeedEvent() {
        return this.feedEvent;
    }
}

