/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.node;

import com.fluxtion.runtime.annotations.Initialise;
import com.fluxtion.runtime.annotations.OnEventHandler;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.annotations.runtime.ServiceRegistered;
import com.fluxtion.runtime.event.NamedFeedEvent;
import com.fluxtion.runtime.input.NamedFeed;
import com.fluxtion.runtime.node.BaseNode;
import com.fluxtion.runtime.node.TableNode;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class NamedFeedTableNode<K, V>
extends BaseNode
implements TableNode<K, V> {
    private final String feedName;
    private final LambdaReflection.SerializableFunction keyMethodReference;
    private final String topicName;
    private final transient Map tableMap = new HashMap();
    private final transient Map tableMapReadonly = Collections.unmodifiableMap(this.tableMap);
    private long lastSequenceNumber;
    private NamedFeedEvent lastFeedEvent;

    public NamedFeedTableNode(String feedName, String keyFunction) {
        this(feedName, null, keyFunction);
    }

    public NamedFeedTableNode(String feedName, String topicName, String keyFunction) {
        Objects.requireNonNull(feedName, "feedName cannot be null");
        Objects.requireNonNull(keyFunction, "keyFunction cannot be null");
        this.feedName = feedName;
        this.topicName = topicName;
        String[] functionString = keyFunction.split("::");
        Class<?> clazz = Class.forName(functionString[0]);
        Method keyMethod = clazz.getMethod(functionString[1], new Class[0]);
        this.keyMethodReference = LambdaReflection.method2Function(keyMethod);
        Objects.requireNonNull(this.keyMethodReference, "keyMethodReference cannot be null");
    }

    public <T, R> NamedFeedTableNode(@AssignToField(value="feedName") String feedName, @AssignToField(value="keyMethodReference") LambdaReflection.SerializableFunction<T, R> keyMethodReference) {
        this.feedName = feedName;
        this.keyMethodReference = keyMethodReference;
        this.topicName = null;
    }

    public <T, R> NamedFeedTableNode(@AssignToField(value="feedName") String feedName, @AssignToField(value="topicName") String topicName, @AssignToField(value="keyMethodReference") LambdaReflection.SerializableFunction<T, R> keyMethodReference) {
        this.feedName = feedName;
        this.topicName = topicName;
        this.keyMethodReference = keyMethodReference;
    }

    @Initialise
    public void initialise() {
        this.lastSequenceNumber = -1L;
        this.auditLog.info("subscribe", this.feedName);
        this.getContext().subscribeToNamedFeed(this.feedName);
    }

    @ServiceRegistered
    public void serviceRegistered(NamedFeed feed, String feedName) {
        if (feedName != null && feedName.equals(this.feedName)) {
            NamedFeedEvent<T>[] eventLog;
            this.auditLog.info("requestSnapshot", feedName).info("eventLogSize", feed.eventLog().length);
            for (NamedFeedEvent namedFeedEvent : eventLog = feed.eventLog()) {
                this.tableUpdate(namedFeedEvent);
            }
        } else {
            this.auditLog.info("ignoreFeedSnapshot", feedName);
        }
    }

    @OnEventHandler(filterVariable="feedName")
    public boolean tableUpdate(NamedFeedEvent feedEvent) {
        if (feedEvent.sequenceNumber() > this.lastSequenceNumber & (this.topicName == null || this.topicName.equals(feedEvent.topic()))) {
            this.lastFeedEvent = feedEvent;
            Object dataItem = feedEvent.data();
            this.lastSequenceNumber = feedEvent.sequenceNumber();
            Object key = this.keyMethodReference.apply(dataItem);
            this.auditLog.debug("received", feedEvent);
            if (feedEvent.delete()) {
                this.auditLog.debug("deletedKey", key);
                this.tableMap.remove(key);
            } else {
                this.auditLog.debug("putKey", key);
                this.tableMap.put(key, dataItem);
            }
            return true;
        }
        return false;
    }

    @Override
    public Map<K, V> getTableMap() {
        return this.tableMapReadonly;
    }

    @Override
    public NamedFeedEvent getLastFeedEvent() {
        return this.lastFeedEvent;
    }
}

