/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.output;

import com.fluxtion.runtime.annotations.OnEventHandler;
import com.fluxtion.runtime.annotations.builder.AssignToField;
import com.fluxtion.runtime.annotations.runtime.ServiceDeregistered;
import com.fluxtion.runtime.annotations.runtime.ServiceRegistered;
import com.fluxtion.runtime.node.SingleNamedNode;
import com.fluxtion.runtime.output.MessageSink;
import com.fluxtion.runtime.output.SinkDeregister;
import com.fluxtion.runtime.output.SinkRegistration;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;

public class SinkPublisher<T>
extends SingleNamedNode {
    private final transient String filterString;
    private Consumer<T> sink;
    private IntConsumer intConsumer;
    private LongConsumer longConsumer;
    private DoubleConsumer doubleConsumer;

    public SinkPublisher(@AssignToField(value="name") String filterString) {
        super(filterString);
        this.filterString = filterString;
    }

    @OnEventHandler(filterVariable="filterString", propagate=false)
    public void sinkRegistration(SinkRegistration<T> sinkRegistration) {
        this.sink = sinkRegistration.getConsumer();
        this.intConsumer = sinkRegistration.getIntConsumer();
        this.longConsumer = sinkRegistration.getLongConsumer();
        this.doubleConsumer = sinkRegistration.getDoubleConsumer();
    }

    @OnEventHandler(filterVariable="filterString", propagate=false)
    public void unregisterSink(SinkDeregister sinkDeregister) {
        this.sink = null;
        this.intConsumer = null;
        this.longConsumer = null;
        this.doubleConsumer = null;
    }

    @ServiceRegistered
    public void messageSinkRegistered(MessageSink<T> messageSink, String name) {
        if (name.equals(this.getName())) {
            this.auditLog.info("registeredMessageSink", name);
            this.sink = messageSink;
        }
    }

    @ServiceDeregistered
    public void messageSinkDeregistered(MessageSink<T> messageSink, String name) {
        if (name.equals(this.getName())) {
            this.auditLog.info("deregisteredMessageSink", name);
            this.sink = null;
        }
    }

    public void publish(T publishItem) {
        if (this.sink != null) {
            this.sink.accept(publishItem);
        }
    }

    public void publishInt(int value) {
        if (this.intConsumer != null) {
            this.intConsumer.accept(value);
        }
    }

    public void publishDouble(double value) {
        if (this.doubleConsumer != null) {
            this.doubleConsumer.accept(value);
        }
    }

    public void publishLong(long value) {
        if (this.longConsumer != null) {
            this.longConsumer.accept(value);
        }
    }
}

