/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.partition;

import com.fluxtion.runtime.StaticEventProcessor;
import com.fluxtion.runtime.lifecycle.BatchHandler;
import com.fluxtion.runtime.lifecycle.Lifecycle;
import com.fluxtion.runtime.partition.LambdaReflection;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Partitioner<E extends StaticEventProcessor>
implements StaticEventProcessor,
Lifecycle,
BatchHandler {
    private HashMap<Class, LambdaReflection.SerializableFunction> class2Function;
    private HashMap<Class, MultiKeyGenerator> class2MultiFunction;
    private final ByteBuffer buffer;
    private final byte[] array;
    private static final int DEFAULT_SIZE = 64;
    private List<Function> charKeyedHandlers;
    private HashMap<Object, E> handlerMap;
    private StaticEventProcessor[] handlerArray;
    private BatchHandler[] batchHandArray;
    private final Supplier<E> factory;
    private Consumer<E> initialiser;

    public Partitioner(Supplier<E> factory, Consumer<E> initialiser) {
        this.factory = factory;
        this.class2Function = new HashMap();
        this.class2MultiFunction = new HashMap();
        this.handlerMap = new HashMap();
        this.handlerArray = new StaticEventProcessor[0];
        this.batchHandArray = new BatchHandler[0];
        this.charKeyedHandlers = new ArrayList<Function>();
        this.array = new byte[64];
        this.buffer = ByteBuffer.wrap(this.array);
        this.initialiser = initialiser;
    }

    public Partitioner(Supplier<E> factory) {
        this(factory, null);
    }

    public <I, K extends CharSequence> void keyPartitioner(Function<I, K> partitionKeyGen) {
        this.charKeyedHandlers.add(partitionKeyGen);
    }

    public <s, t> void partition(LambdaReflection.SerializableFunction<s, t> supplier) {
        Class<?> clazz = supplier.getContainingClass();
        this.class2Function.put(clazz, supplier);
    }

    public <s, t> void partition(LambdaReflection.SerializableFunction<s, ?> ... supplier) {
        Class<?> clazz = supplier[0].getContainingClass();
        List<LambdaReflection.SerializableFunction> supplierList = Arrays.asList(supplier);
        this.class2MultiFunction.put(clazz, new MultiKeyGenerator(supplierList));
    }

    @Override
    public void onEvent(Object e) {
        StaticEventProcessor handler;
        LambdaReflection.SerializableFunction f = this.class2Function.get(e.getClass());
        MultiKeyGenerator multiF = this.class2MultiFunction.get(e.getClass());
        boolean keyed = this.charsequenceKeyProcess(e);
        boolean filtered = f != null | multiF != null | keyed;
        if (f != null) {
            handler = this.handlerMap.computeIfAbsent(f.apply(e), t -> this.initialise());
            this.pushEvent(handler, e);
        }
        if (multiF != null) {
            handler = this.handlerMap.computeIfAbsent(multiF.generateKey(e), t -> {
                multiF.newValueList();
                return this.initialise();
            });
            this.pushEvent(handler, e);
        }
        if (!filtered) {
            for (StaticEventProcessor eventHandler : this.handlerArray) {
                this.pushEvent(eventHandler, e);
            }
        }
    }

    public E getProcessor(Object key) {
        return (E)((StaticEventProcessor)this.handlerMap.get(key));
    }

    private boolean charsequenceKeyProcess(Object e) {
        boolean matched = false;
        for (int i = 0; i < this.charKeyedHandlers.size(); ++i) {
            Function keyGen = this.charKeyedHandlers.get(i);
            CharSequence key = (CharSequence)keyGen.apply(e);
            if (key != null && key.length() == 1 && key.charAt(0) == '*') {
                return matched;
            }
            matched = true;
            if (key == null) continue;
            this.buffer.clear();
            for (int j = 0; j < key.length(); ++j) {
                this.buffer.put((byte)key.charAt(j));
            }
            this.buffer.flip();
            StaticEventProcessor ret = (StaticEventProcessor)this.handlerMap.get(this.buffer);
            if (ret != null) {
                this.pushEvent(ret, e);
                continue;
            }
            ret = this.initialise();
            this.handlerMap.put(ByteBuffer.wrap(Arrays.copyOf(this.array, this.buffer.limit())), ret);
            this.pushEvent(ret, e);
        }
        return matched;
    }

    private void pushEvent(StaticEventProcessor handler, Object e) {
        handler.onEvent(e);
    }

    private E initialise() {
        StaticEventProcessor newHandler = (StaticEventProcessor)this.factory.get();
        this.handlerArray = Arrays.copyOf(this.handlerArray, this.handlerArray.length + 1);
        this.handlerArray[this.handlerArray.length - 1] = newHandler;
        if (newHandler instanceof Lifecycle) {
            ((Lifecycle)((Object)newHandler)).init();
        }
        if (newHandler instanceof BatchHandler) {
            this.batchHandArray = Arrays.copyOf(this.batchHandArray, this.batchHandArray.length + 1);
            this.batchHandArray[this.batchHandArray.length - 1] = (BatchHandler)((Object)newHandler);
        }
        if (this.initialiser != null) {
            this.initialiser.accept(newHandler);
        }
        return (E)newHandler;
    }

    @Override
    public void tearDown() {
        Arrays.stream(this.handlerArray).filter(e -> e instanceof Lifecycle).map(Lifecycle.class::cast).forEach(Lifecycle::tearDown);
    }

    @Override
    public void batchPause() {
        for (BatchHandler batchHandler : this.batchHandArray) {
            batchHandler.batchPause();
        }
    }

    @Override
    public void batchEnd() {
        for (BatchHandler batchHandler : this.batchHandArray) {
            batchHandler.batchEnd();
        }
    }

    @Override
    public void init() {
    }

    private class MultiKeyGenerator {
        List<LambdaReflection.SerializableFunction> mapper;
        List values;

        MultiKeyGenerator(List<LambdaReflection.SerializableFunction> mapper) {
            this.mapper = mapper;
            this.values = new ArrayList();
        }

        List generateKey(Object e) {
            this.values.clear();
            for (int i = 0; i < this.mapper.size(); ++i) {
                LambdaReflection.SerializableFunction f = this.mapper.get(i);
                this.values.add(f.apply(e));
            }
            return this.values;
        }

        void newValueList() {
            this.values = new ArrayList();
        }
    }
}

