/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.service;

import com.fluxtion.runtime.annotations.feature.Preview;
import com.fluxtion.runtime.lifecycle.Lifecycle;

@Preview
public class Service<T>
implements Lifecycle {
    private final Class<T> serviceClass;
    private final String serviceName;
    private final T instance;

    public <S extends T> Service(S instance, Class<T> serviceClass, String serviceName) {
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.instance = instance;
    }

    public <S extends T> Service(S instance, String serviceName) {
        this.serviceClass = instance.getClass();
        this.serviceName = serviceName;
        this.instance = instance;
    }

    public <S extends T> Service(S instance, Class<T> serviceClass) {
        this(instance, serviceClass, serviceClass.getCanonicalName());
    }

    public <S extends T> Service(S instance) {
        this(instance, instance.getClass());
    }

    @Override
    public void init() {
        if (this.instance instanceof Lifecycle) {
            ((Lifecycle)this.instance).init();
        }
    }

    @Override
    public void start() {
        if (this.instance instanceof Lifecycle) {
            ((Lifecycle)this.instance).start();
        }
    }

    @Override
    public void startComplete() {
        if (this.instance instanceof Lifecycle) {
            ((Lifecycle)this.instance).startComplete();
        }
    }

    @Override
    public void stop() {
        if (this.instance instanceof Lifecycle) {
            ((Lifecycle)this.instance).stop();
        }
    }

    @Override
    public void tearDown() {
        if (this.instance instanceof Lifecycle) {
            ((Lifecycle)this.instance).tearDown();
        }
    }

    public Class<T> serviceClass() {
        return this.serviceClass;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public T instance() {
        return this.instance;
    }

    public String toString() {
        return "Service(serviceClass=" + this.serviceClass() + ", serviceName=" + this.serviceName() + ", instance=" + this.instance() + ")";
    }
}

