/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.service;

import com.fluxtion.runtime.EventProcessorContextListener;
import com.fluxtion.runtime.annotations.builder.FluxtionIgnore;
import com.fluxtion.runtime.annotations.feature.Preview;
import com.fluxtion.runtime.annotations.runtime.ServiceDeregistered;
import com.fluxtion.runtime.annotations.runtime.ServiceRegistered;
import com.fluxtion.runtime.audit.Auditor;
import com.fluxtion.runtime.node.SingleNamedNode;
import com.fluxtion.runtime.service.Service;
import com.fluxtion.runtime.service.ServiceListener;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Preview
public class ServiceRegistryNode
extends SingleNamedNode
implements Auditor,
ServiceListener {
    public static final String NODE_NAME = "serviceRegistry";
    @FluxtionIgnore
    private final Map<RegistrationKey, List<Callback>> serviceCallbackMap = new HashMap<RegistrationKey, List<Callback>>();
    @FluxtionIgnore
    private final Map<RegistrationKey, List<Callback>> serviceDeregisterCallbackMap = new HashMap<RegistrationKey, List<Callback>>();
    @FluxtionIgnore
    private final Map<Class<?>, List<Callback>> serviceWithNameCallbacks = new HashMap();
    @FluxtionIgnore
    private final Map<Class<?>, List<Callback>> serviceDeregisterWithNameCallbacks = new HashMap();
    @FluxtionIgnore
    private final RegistrationKey tempKey = new RegistrationKey();

    public ServiceRegistryNode() {
        super(NODE_NAME);
    }

    @Override
    public void registerService(Service<?> service) {
        this.auditLog.info("registerService", service);
        this.tempKey.serviceClass(service.serviceClass()).serviceName(service.serviceName());
        List<Callback> callBackMethods = this.serviceCallbackMap.get(this.tempKey);
        if (callBackMethods != null) {
            for (int i = 0; i < callBackMethods.size(); ++i) {
                Callback callBackMethod = callBackMethods.get(i);
                callBackMethod.invoke(service.instance(), service.serviceName());
            }
        }
        for (Callback nameCallback : this.serviceWithNameCallbacks.getOrDefault(service.serviceClass(), Collections.emptyList())) {
            nameCallback.invoke(service.instance(), service.serviceName());
        }
    }

    @Override
    public void deRegisterService(Service<?> service) {
        this.auditLog.info("deRegisterService", service);
        this.tempKey.serviceClass(service.serviceClass()).serviceName(service.serviceName());
        List<Callback> callBackMethods = this.serviceDeregisterCallbackMap.get(this.tempKey);
        if (callBackMethods != null) {
            for (int i = 0; i < callBackMethods.size(); ++i) {
                Callback callBackMethod = callBackMethods.get(i);
                callBackMethod.invoke(service.instance(), service.serviceName());
            }
        }
        for (Callback nameCallback : this.serviceDeregisterWithNameCallbacks.getOrDefault(service.serviceClass(), Collections.emptyList())) {
            nameCallback.invoke(service.instance(), service.serviceName());
        }
    }

    @Override
    public void init() {
        this.serviceCallbackMap.clear();
    }

    @Override
    public void nodeRegistered(Object node, String nodeName) {
        Method[] methods;
        if (node instanceof EventProcessorContextListener) {
            ((EventProcessorContextListener)node).currentContext(this.getEventProcessorContext());
        }
        Class<?> clazz = node.getClass();
        for (Method method : methods = clazz.getMethods()) {
            ServiceDeregistered deregisterAnnotation;
            boolean namedService;
            ServiceRegistered registerAnnotation = method.getAnnotation(ServiceRegistered.class);
            int parameterCount = method.getParameterCount();
            boolean bl = namedService = parameterCount == 2 && CharSequence.class.isAssignableFrom(method.getParameterTypes()[1]);
            if (registerAnnotation != null && Modifier.isPublic(method.getModifiers()) && (parameterCount == 1 || namedService)) {
                Class<?> parameterType = method.getParameterTypes()[0];
                RegistrationKey key = new RegistrationKey(parameterType, registerAnnotation.value().isEmpty() ? parameterType.getCanonicalName() : registerAnnotation.value());
                if (namedService) {
                    this.serviceWithNameCallbacks.compute(parameterType, (k, v) -> {
                        List list = v == null ? new ArrayList() : v;
                        list.add(new Callback(method, node, namedService));
                        return list;
                    });
                } else {
                    this.serviceCallbackMap.compute(key, (k, v) -> {
                        List list = v == null ? new ArrayList() : v;
                        list.add(new Callback(method, node, namedService));
                        return list;
                    });
                }
            }
            if ((deregisterAnnotation = method.getAnnotation(ServiceDeregistered.class)) == null || !Modifier.isPublic(method.getModifiers()) || parameterCount != 1 && !namedService) continue;
            Class<?> parameterType = method.getParameterTypes()[0];
            RegistrationKey key = new RegistrationKey(parameterType, deregisterAnnotation.value().isEmpty() ? parameterType.getCanonicalName() : deregisterAnnotation.value());
            if (namedService) {
                this.serviceDeregisterWithNameCallbacks.compute(parameterType, (k, v) -> {
                    List list = v == null ? new ArrayList() : v;
                    list.add(new Callback(method, node, namedService));
                    return list;
                });
                continue;
            }
            this.serviceDeregisterCallbackMap.compute(key, (k, v) -> {
                List list = v == null ? new ArrayList() : v;
                list.add(new Callback(method, node, false));
                return list;
            });
        }
    }

    private static class Callback {
        Method method;
        Object node;
        boolean namedService;

        void invoke(Object service, String name) {
            if (this.namedService) {
                this.method.invoke(this.node, service, name);
            } else {
                this.method.invoke(this.node, service);
            }
        }

        public Method method() {
            return this.method;
        }

        public Object node() {
            return this.node;
        }

        public boolean namedService() {
            return this.namedService;
        }

        public Callback method(Method method) {
            this.method = method;
            return this;
        }

        public Callback node(Object node) {
            this.node = node;
            return this;
        }

        public Callback namedService(boolean namedService) {
            this.namedService = namedService;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Callback)) {
                return false;
            }
            Callback other = (Callback)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.namedService() != other.namedService()) {
                return false;
            }
            Method this$method = this.method();
            Method other$method = other.method();
            if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
                return false;
            }
            Object this$node = this.node();
            Object other$node = other.node();
            return !(this$node == null ? other$node != null : !this$node.equals(other$node));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Callback;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.namedService() ? 79 : 97);
            Method $method = this.method();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            Object $node = this.node();
            result = result * 59 + ($node == null ? 43 : $node.hashCode());
            return result;
        }

        public String toString() {
            return "ServiceRegistryNode.Callback(method=" + this.method() + ", node=" + this.node() + ", namedService=" + this.namedService() + ")";
        }

        public Callback(Method method, Object node, boolean namedService) {
            this.method = method;
            this.node = node;
            this.namedService = namedService;
        }

        public Callback() {
        }
    }

    private static class RegistrationKey {
        Class<?> serviceClass;
        String serviceName;

        public Class<?> serviceClass() {
            return this.serviceClass;
        }

        public String serviceName() {
            return this.serviceName;
        }

        public RegistrationKey serviceClass(Class<?> serviceClass) {
            this.serviceClass = serviceClass;
            return this;
        }

        public RegistrationKey serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegistrationKey)) {
                return false;
            }
            RegistrationKey other = (RegistrationKey)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Class<?> this$serviceClass = this.serviceClass();
            Class<?> other$serviceClass = other.serviceClass();
            if (this$serviceClass == null ? other$serviceClass != null : !this$serviceClass.equals(other$serviceClass)) {
                return false;
            }
            String this$serviceName = this.serviceName();
            String other$serviceName = other.serviceName();
            return !(this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RegistrationKey;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $serviceClass = this.serviceClass();
            result = result * 59 + ($serviceClass == null ? 43 : $serviceClass.hashCode());
            String $serviceName = this.serviceName();
            result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
            return result;
        }

        public String toString() {
            return "ServiceRegistryNode.RegistrationKey(serviceClass=" + this.serviceClass() + ", serviceName=" + this.serviceName() + ")";
        }

        public RegistrationKey(Class<?> serviceClass, String serviceName) {
            this.serviceClass = serviceClass;
            this.serviceName = serviceName;
        }

        public RegistrationKey() {
        }
    }
}

