/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface CollectionHelper {
    @SafeVarargs
    public static <E> List<E> listOf(E ... elements) {
        if (elements.length == 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(elements));
    }

    @SafeVarargs
    public static <K, V> Map<K, V> ofEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        if (entries.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<K, V> map = new HashMap<K, V>(entries.length);
        for (Map.Entry<K, V> entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }
}

