/*
 * Decompiled with CFR 0.152.
 */
package com.fluxtion.runtime.util;

import com.fluxtion.runtime.partition.LambdaReflection;
import java.util.ArrayList;
import java.util.List;

public class ObjectPool<T> {
    private final LambdaReflection.SerializableSupplier<T> supplier;
    private final transient List<T> freeList = new ArrayList<T>();

    public ObjectPool(LambdaReflection.SerializableSupplier<T> supplier) {
        this.supplier = supplier;
    }

    public T checkOut() {
        if (this.freeList.isEmpty()) {
            return this.supplier.get();
        }
        return this.freeList.remove(this.freeList.size() - 1);
    }

    public void checkIn(T returnedInstance) {
        this.freeList.add(returnedInstance);
    }

    public void reset() {
        this.freeList.clear();
    }
}

