/*
 * Decompiled with CFR 0.152.
 */
package com.fmarslan.spring.base.common.exceptions;

import java.util.Arrays;
import java.util.function.Function;

public abstract class AbstractException
extends RuntimeException {
    private static final long serialVersionUID = 8529479987398884574L;
    private String message;
    private Object[] params;
    private Function<String, String> translateFunction;

    public AbstractException() {
    }

    public AbstractException(String message, Throwable cause) {
        super(message, cause);
        this.message = message;
    }

    public AbstractException(String message) {
        super(message);
        this.message = message;
    }

    public AbstractException(String message, Object ... params) {
        super(message);
        this.message = message;
        this.params = params;
    }

    public AbstractException(Throwable cause) {
        super(cause);
        this.message = cause.getMessage();
    }

    public abstract String getCode();

    public void translate(Function<String, String> translateFunction) {
        this.translateFunction = translateFunction;
    }

    public int getStatusCode() {
        return 400;
    }

    @Override
    public String getMessage() {
        if (this.translateFunction != null) {
            this.message = this.translateFunction.apply(this.message);
            Arrays.stream(this.params).forEach(x -> {
                if (x instanceof String) {
                    x = this.translateFunction.apply((String)x);
                }
            });
        }
        if (this.params != null && this.params.length > 0) {
            return String.format(this.message, this.params);
        }
        return this.message;
    }

    @Override
    public String getLocalizedMessage() {
        return this.getMessage();
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

