/*
 * Decompiled with CFR 0.152.
 */
package com.fmarslan.spring.base.common.utils;

import java.util.Random;

public class RandomUtils {
    public static final char[] ALPHABET_NUMBER = new char[]{'Q', 'A', 'Z', 'W', 'S', 'X', 'E', 'D', 'C', 'R', 'F', 'V', 'T', 'G', 'B', 'Y', 'H', 'N', 'U', 'J', 'M', 'I', 'K', 'O', 'L', 'P', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};
    public static final char[] ALPHABET = new char[]{'Q', 'A', 'Z', 'W', 'S', 'X', 'E', 'D', 'C', 'R', 'F', 'V', 'T', 'G', 'B', 'Y', 'H', 'N', 'U', 'J', 'M', 'I', 'K', 'O', 'L', 'P'};
    public static final char[] NUMBER = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0'};

    public static String generateString(int minLength, int maxLength, char[] charset) {
        int length = minLength;
        if (minLength < 0) {
            length = new Random().nextInt(100);
        }
        if (minLength >= 0 && minLength < maxLength) {
            length = new Random().nextInt(maxLength - minLength) + minLength;
        }
        String generatedString = "";
        for (int i = 0; i < length; ++i) {
            generatedString = generatedString + charset[new Random().nextInt(charset.length)];
        }
        return generatedString;
    }

    public static String generateString(int minLength, int maxLength) {
        return RandomUtils.generateString(minLength, maxLength, ALPHABET_NUMBER);
    }

    public static String generateString(int length) {
        return RandomUtils.generateString(length, -1);
    }

    public static String generateString() {
        return RandomUtils.generateString(-1, -1);
    }

    public static String padRightRandom(String txt, int size, char[] charset) {
        if (txt.length() >= size) {
            return txt;
        }
        return txt + RandomUtils.generateString(size - txt.length(), -1, charset);
    }

    public static String padRightRandom(String txt, int size) {
        return RandomUtils.padRightRandom(txt, size, ALPHABET_NUMBER);
    }

    public static String padLeftRandom(String txt, int size, char[] charset) {
        if (txt.length() >= size) {
            return txt;
        }
        return RandomUtils.generateString(size - txt.length(), -1, charset) + txt;
    }

    public static String padLeftRandom(String txt, int size) {
        return RandomUtils.padLeftRandom(txt, size, ALPHABET_NUMBER);
    }
}

