/*
 * Decompiled with CFR 0.152.
 */
package com.fmsirvent.ParallaxEverywhere;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Display;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.TextView;
import com.fmsirvent.ParallaxEverywhere.R;
import com.fmsirvent.ParallaxEverywhere.Utils.InterpolatorSelector;

public class PEWTextView
extends TextView {
    public boolean reverseX = false;
    public boolean reverseY = false;
    public int scrollSpaceX = 0;
    public int scrollSpaceY = 0;
    public boolean updateOnDraw = false;
    public boolean blockParallaxX = false;
    public boolean blockParallaxY = false;
    private int screenHeight;
    private int screenWidth;
    private float heightView;
    private float widthView;
    private Interpolator interpolator = new LinearInterpolator();
    private ViewTreeObserver.OnScrollChangedListener mOnScrollChangedListener = null;
    private ViewTreeObserver.OnGlobalLayoutListener mOnGlobalLayoutListener = null;
    private ViewTreeObserver.OnDrawListener onDrawListener = null;

    public PEWTextView(Context context) {
        super(context);
        if (!this.isInEditMode()) {
            this.parallaxAnimation();
        }
    }

    public PEWTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.checkAttributes(attrs);
            this.parallaxAnimation();
        }
    }

    public PEWTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (!this.isInEditMode()) {
            this.checkAttributes(attrs);
            this.parallaxAnimation();
        }
    }

    private void checkAttributes(AttributeSet attrs) {
        TypedArray arr = this.getContext().obtainStyledAttributes(attrs, R.styleable.PEWAttrs);
        int reverse = arr.getInt(R.styleable.PEWAttrs_reverse, 1);
        this.updateOnDraw = arr.getBoolean(R.styleable.PEWAttrs_update_onDraw, false);
        this.blockParallaxX = arr.getBoolean(R.styleable.PEWAttrs_block_parallax_x, false);
        this.blockParallaxY = arr.getBoolean(R.styleable.PEWAttrs_block_parallax_y, false);
        this.reverseX = false;
        this.reverseY = false;
        switch (reverse) {
            case 1: {
                break;
            }
            case 2: {
                this.reverseX = true;
                break;
            }
            case 3: {
                this.reverseY = true;
                break;
            }
            case 4: {
                this.reverseX = true;
                this.reverseY = true;
            }
        }
        this.scrollSpaceX = arr.getDimensionPixelSize(R.styleable.PEWAttrs_parallax_x, 0);
        this.scrollSpaceY = arr.getDimensionPixelSize(R.styleable.PEWAttrs_parallax_y, 0);
        int interpolationId = arr.getInt(R.styleable.PEWAttrs_interpolation, 0);
        this.interpolator = InterpolatorSelector.interpolatorId(interpolationId);
        arr.recycle();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mOnScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

            public void onScrollChanged() {
                PEWTextView.this.applyParallax();
            }
        };
        this.mOnGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                PEWTextView.this.heightView = PEWTextView.this.getHeight();
                PEWTextView.this.widthView = PEWTextView.this.getWidth();
                PEWTextView.this.applyParallax();
            }
        };
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        viewTreeObserver.addOnScrollChangedListener(this.mOnScrollChangedListener);
        viewTreeObserver.addOnGlobalLayoutListener(this.mOnGlobalLayoutListener);
        if (this.updateOnDraw && Build.VERSION.SDK_INT >= 16) {
            this.onDrawListener = new ViewTreeObserver.OnDrawListener(){

                public void onDraw() {
                    PEWTextView.this.applyParallax();
                }
            };
            viewTreeObserver.addOnDrawListener(this.onDrawListener);
        }
        this.parallaxAnimation();
    }

    protected void onDetachedFromWindow() {
        ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
        viewTreeObserver.removeOnScrollChangedListener(this.mOnScrollChangedListener);
        if (Build.VERSION.SDK_INT >= 16) {
            viewTreeObserver.removeOnGlobalLayoutListener(this.mOnGlobalLayoutListener);
        } else {
            viewTreeObserver.removeGlobalOnLayoutListener(this.mOnGlobalLayoutListener);
        }
        if (this.updateOnDraw && Build.VERSION.SDK_INT >= 16) {
            viewTreeObserver.removeOnDrawListener(this.onDrawListener);
        }
        super.onDetachedFromWindow();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.applyParallax();
    }

    private void parallaxAnimation() {
        this.initSizeScreen();
        this.applyParallax();
    }

    private void initSizeScreen() {
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            Point size = new Point();
            display.getSize(size);
            this.screenHeight = size.y;
            this.screenWidth = size.x;
        } else {
            this.screenHeight = display.getHeight();
            this.screenWidth = display.getWidth();
        }
    }

    private void applyParallax() {
        int[] location = new int[2];
        this.getLocationOnScreen(location);
        if (this.scrollSpaceY != 0 && !this.blockParallaxY) {
            float locationY = location[1];
            float locationUsableY = locationY + this.heightView / 2.0f;
            float scrollDeltaY = locationUsableY / (float)this.screenHeight;
            float interpolatedScrollDeltaY = this.interpolator.getInterpolation(scrollDeltaY);
            if (this.reverseY) {
                this.setMyScrollY((int)(Math.min(Math.max(0.5f - interpolatedScrollDeltaY, -0.5f), 0.5f) * (float)(-this.scrollSpaceY)));
            } else {
                this.setMyScrollY((int)(Math.min(Math.max(0.5f - interpolatedScrollDeltaY, -0.5f), 0.5f) * (float)this.scrollSpaceY));
            }
        }
        if (this.scrollSpaceX != 0 && !this.blockParallaxX) {
            float locationX = location[0];
            float locationUsableX = locationX + this.widthView / 2.0f;
            float scrollDeltaX = locationUsableX / (float)this.screenWidth;
            float interpolatedScrollDeltaX = this.interpolator.getInterpolation(scrollDeltaX);
            if (this.reverseX) {
                this.setMyScrollX((int)(Math.min(Math.max(0.5f - interpolatedScrollDeltaX, -0.5f), 0.5f) * (float)(-this.scrollSpaceX)));
            } else {
                this.setMyScrollX((int)(Math.min(Math.max(0.5f - interpolatedScrollDeltaX, -0.5f), 0.5f) * (float)this.scrollSpaceX));
            }
        }
    }

    private void setMyScrollX(int value) {
        if (Build.VERSION.SDK_INT >= 14) {
            this.setScrollX(value);
        } else {
            this.scrollTo(value, this.getScrollY());
        }
    }

    private void setMyScrollY(int value) {
        if (Build.VERSION.SDK_INT >= 14) {
            this.setScrollY(value);
        } else {
            this.scrollTo(this.getScrollX(), value);
        }
    }

    public void setInterpolator(Interpolator interpol) {
        this.interpolator = interpol;
    }

    public boolean isReverseX() {
        return this.reverseX;
    }

    public void setReverseX(boolean reverseX) {
        this.reverseX = reverseX;
    }

    public boolean isReverseY() {
        return this.reverseY;
    }

    public void setReverseY(boolean reverseY) {
        this.reverseY = reverseY;
    }

    public int getScrollSpaceX() {
        return this.scrollSpaceX;
    }

    public void setScrollSpaceX(int scrollSpaceX) {
        this.scrollSpaceX = scrollSpaceX;
    }

    public int getScrollSpaceY() {
        return this.scrollSpaceY;
    }

    public void setScrollSpaceY(int scrollSpaceY) {
        this.scrollSpaceY = scrollSpaceY;
    }

    public boolean isBlockParallaxX() {
        return this.blockParallaxX;
    }

    public void setBlockParallaxX(boolean blockParallaxX) {
        this.blockParallaxX = blockParallaxX;
    }

    public boolean isBlockParallaxY() {
        return this.blockParallaxY;
    }

    public void setBlockParallaxY(boolean blockParallaxY) {
        this.blockParallaxY = blockParallaxY;
    }
}

