/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public final class Headers
implements Serializable {
    private static final Headers emptyHeaders = new Headers(Collections.emptyMap());
    private Map<String, List<String>> headers;
    private static Pattern headerName = Pattern.compile("[A-Za-z0-9!#%&'*+-.^_`|~]+");

    private Headers(Map<String, List<String>> headersIn) {
        this.headers = headersIn;
    }

    public Map getAll() {
        return this.headers;
    }

    public static String canonicalKey(String key) {
        if (!headerName.matcher(key).matches()) {
            return key;
        }
        CharSequence[] parts = key.split("-", -1);
        for (int i = 0; i < parts.length; ++i) {
            String p = parts[i];
            if (p.length() <= 0) continue;
            parts[i] = p.substring(0, 1).toUpperCase() + p.substring(1).toLowerCase();
        }
        return String.join((CharSequence)"-", parts);
    }

    public static Headers fromMap(Map<String, String> headers) {
        Objects.requireNonNull(headers, "headersIn");
        HashMap h = new HashMap();
        headers.forEach((k, v) -> h.put(Headers.canonicalKey(k), Collections.singletonList(v)));
        return new Headers(Collections.unmodifiableMap(new HashMap(h)));
    }

    public static Headers fromMultiHeaderMap(Map<String, List<String>> headers) {
        HashMap hm = new HashMap();
        headers.forEach((k, vs) -> {
            List cfr_ignored_0 = hm.put(Headers.canonicalKey(k), new ArrayList(vs));
        });
        return new Headers(Collections.unmodifiableMap(new HashMap<String, List<String>>(Objects.requireNonNull(headers))));
    }

    public static Headers emptyHeaders() {
        return emptyHeaders;
    }

    public Headers setHeaders(Map<String, List<String>> vals) {
        Objects.requireNonNull(vals, "vals");
        HashMap<String, List<String>> nm = new HashMap<String, List<String>>(this.headers);
        vals.forEach((k, vs) -> {
            vs.forEach(v -> Objects.requireNonNull(v, "header list contains null entries"));
            nm.put(Headers.canonicalKey(k), (List<String>)vs);
        });
        return new Headers(nm);
    }

    public Headers addHeader(String key, String v1, String ... vs) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(key, "value");
        String canonKey = Headers.canonicalKey(key);
        HashMap<String, List<String>> nm = new HashMap<String, List<String>>(this.headers);
        List current = (List)nm.get(canonKey);
        if (current == null) {
            ArrayList<String> s = new ArrayList<String>();
            s.add(v1);
            s.addAll(Arrays.asList(vs));
            nm.put(canonKey, Collections.unmodifiableList(s));
        } else {
            ArrayList<String> s = new ArrayList<String>(current);
            s.add(v1);
            s.addAll(Arrays.asList(vs));
            nm.put(canonKey, Collections.unmodifiableList(s));
        }
        return new Headers(nm);
    }

    public Headers setHeader(String key, String v1, String ... vs) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(v1, "v1");
        Stream.of(vs).forEach(v -> Objects.requireNonNull(v, "vs"));
        HashMap<String, List<String>> nm = new HashMap<String, List<String>>(this.headers);
        ArrayList<String> s = new ArrayList<String>();
        s.add(v1);
        s.addAll(Arrays.asList(vs));
        nm.put(Headers.canonicalKey(key), Collections.unmodifiableList(s));
        return new Headers(Collections.unmodifiableMap(nm));
    }

    public Headers setHeader(String key, Collection<String> vs) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(vs, "vs");
        if (vs.size() == 0) {
            throw new IllegalArgumentException("can't set keys to an empty list");
        }
        vs.forEach(v -> Objects.requireNonNull(v, "vs"));
        HashMap<String, List<String>> nm = new HashMap<String, List<String>>(this.headers);
        nm.put(Headers.canonicalKey(key), Collections.unmodifiableList(new ArrayList<String>(vs)));
        return new Headers(Collections.unmodifiableMap(nm));
    }

    public Headers removeHeader(String key) {
        Objects.requireNonNull(key, "key");
        String canonKey = Headers.canonicalKey(key);
        if (!this.headers.containsKey(canonKey)) {
            return this;
        }
        HashMap<String, List<String>> nm = new HashMap<String, List<String>>(this.headers);
        nm.remove(canonKey);
        return new Headers(Collections.unmodifiableMap(nm));
    }

    public Optional<String> get(String key) {
        Objects.requireNonNull(key, "Key cannot be null");
        String canonKey = Headers.canonicalKey(key);
        List<String> val = this.headers.get(canonKey);
        if (val == null) {
            return Optional.empty();
        }
        return Optional.of(val.get(0));
    }

    public Collection<String> keys() {
        return this.headers.keySet();
    }

    public Map<String, List<String>> asMap() {
        return this.headers;
    }

    public List<String> getAllValues(String key) {
        return this.headers.getOrDefault(Headers.canonicalKey(key), Collections.emptyList());
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Headers)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.headers.equals(((Headers)other).headers);
    }

    public String toString() {
        return Objects.toString(this.headers);
    }
}

