/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.api;

import com.fnproject.fn.api.Headers;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;

public interface OutputEvent {
    public static final String CONTENT_TYPE_HEADER = "Content-Type";

    public Status getStatus();

    default public boolean isSuccess() {
        return this.getStatus() == Status.Success;
    }

    default public Optional<String> getContentType() {
        return this.getHeaders().get(CONTENT_TYPE_HEADER);
    }

    public Headers getHeaders();

    public void writeToOutput(OutputStream var1) throws IOException;

    default public OutputEvent withHeaders(final Headers headers) {
        Objects.requireNonNull(headers, "headers");
        final OutputEvent a = this;
        return new OutputEvent(){

            @Override
            public Status getStatus() {
                return a.getStatus();
            }

            @Override
            public Headers getHeaders() {
                return headers;
            }

            @Override
            public void writeToOutput(OutputStream out) throws IOException {
                a.writeToOutput(out);
            }
        };
    }

    public static OutputEvent fromBytes(byte[] bytes, Status status, String contentType) {
        return OutputEvent.fromBytes(bytes, status, contentType, Headers.emptyHeaders());
    }

    public static OutputEvent fromBytes(final byte[] bytes, final Status status, String contentType, Headers headers) {
        Objects.requireNonNull(bytes, "bytes");
        Objects.requireNonNull(status, "status");
        Objects.requireNonNull(headers, "headers");
        final Headers newHeaders = contentType == null ? Headers.emptyHeaders() : headers.setHeader(CONTENT_TYPE_HEADER, contentType, new String[0]);
        return new OutputEvent(){

            @Override
            public Status getStatus() {
                return status;
            }

            @Override
            public Headers getHeaders() {
                return newHeaders;
            }

            @Override
            public void writeToOutput(OutputStream out) throws IOException {
                out.write(bytes);
            }
        };
    }

    public static OutputEvent emptyResult(final Status status) {
        Objects.requireNonNull(status, "status");
        return new OutputEvent(){

            @Override
            public Status getStatus() {
                return status;
            }

            @Override
            public Headers getHeaders() {
                return Headers.emptyHeaders();
            }

            @Override
            public void writeToOutput(OutputStream out) throws IOException {
            }
        };
    }

    public static enum Status {
        Success(200),
        FunctionError(502),
        FunctionTimeout(504),
        InternalError(500);

        private final int code;

        private Status(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

