/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime.httpgateway;

import com.fnproject.fn.api.Headers;
import com.fnproject.fn.api.InvocationContext;
import com.fnproject.fn.api.QueryParameters;
import com.fnproject.fn.api.httpgateway.HTTPGatewayContext;
import com.fnproject.fn.runtime.httpgateway.QueryParametersParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FunctionHTTPGatewayContext
implements HTTPGatewayContext {
    private final InvocationContext invocationContext;
    private final Headers httpRequestHeaders;
    private final String method;
    private final String requestUrl;
    private final QueryParameters queryParameters;

    public FunctionHTTPGatewayContext(InvocationContext invocationContext) {
        this.invocationContext = Objects.requireNonNull(invocationContext, "invocationContext");
        HashMap<String, List> myHeaders = new HashMap<String, List>();
        String requestUri = "";
        String method = "";
        for (Map.Entry e : invocationContext.getRequestHeaders().asMap().entrySet()) {
            String httpKey;
            String key = (String)e.getKey();
            if (key.startsWith("Fn-Http-H-") && (httpKey = key.substring("Fn-Http-H-".length())).length() > 0) {
                myHeaders.put(httpKey, (List)e.getValue());
            }
            if (key.equals("Fn-Http-Request-Url")) {
                requestUri = (String)((List)e.getValue()).get(0);
            }
            if (!key.equals("Fn-Http-Method")) continue;
            method = (String)((List)e.getValue()).get(0);
        }
        this.queryParameters = QueryParametersParser.getParams(requestUri);
        this.requestUrl = requestUri;
        this.method = method;
        this.httpRequestHeaders = Headers.emptyHeaders().setHeaders(myHeaders);
    }

    public InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    public Headers getHeaders() {
        return this.httpRequestHeaders;
    }

    public String getRequestURL() {
        return this.requestUrl;
    }

    public String getMethod() {
        return this.method;
    }

    public QueryParameters getQueryParameters() {
        return this.queryParameters;
    }

    public void addResponseHeader(String key, String value) {
        this.invocationContext.addResponseHeader("Fn-Http-H-" + key, value);
    }

    public void setResponseHeader(String key, String value, String ... vs) {
        if (Headers.canonicalKey((String)key).equals("Content-Type")) {
            this.invocationContext.setResponseContentType(value);
            this.invocationContext.setResponseHeader("Fn-Http-H-" + key, value, new String[0]);
        } else {
            this.invocationContext.setResponseHeader("Fn-Http-H-" + key, value, vs);
        }
    }

    public void setStatusCode(int code) {
        if (code < 100 || code >= 600) {
            throw new IllegalArgumentException("Invalid HTTP status code: " + code);
        }
        this.invocationContext.setResponseHeader("Fn-Http-Status", "" + code, new String[0]);
    }
}

