/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime.ntv;

import com.fnproject.fn.runtime.ntv.UnixSocket;
import com.fnproject.fn.runtime.ntv.UnixSocketException;
import com.fnproject.fn.runtime.ntv.UnixSocketNative;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicBoolean;

public class UnixServerSocket
implements Closeable {
    private final int fd;
    private final AtomicBoolean closed = new AtomicBoolean();

    private UnixServerSocket(int fd) {
        this.fd = fd;
    }

    public static UnixServerSocket listen(String fileName, int backlog) throws IOException {
        int fd = UnixSocketNative.socket();
        try {
            UnixSocketNative.bind(fd, fileName);
        }
        catch (UnixSocketException e) {
            UnixSocketNative.close(fd);
            throw e;
        }
        try {
            UnixSocketNative.listen(fd, backlog);
        }
        catch (UnixSocketException e) {
            UnixSocketNative.close(fd);
            throw e;
        }
        return new UnixServerSocket(fd);
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            UnixSocketNative.close(this.fd);
        }
    }

    public UnixSocket accept(long timeoutMillis) throws IOException {
        if (this.closed.get()) {
            throw new SocketException("accept on closed socket");
        }
        int newFd = UnixSocketNative.accept(this.fd, timeoutMillis);
        if (newFd == 0) {
            return null;
        }
        return new UnixSocket(newFd);
    }
}

