/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime;

import com.fnproject.fn.api.FnConfiguration;
import com.fnproject.fn.api.MethodWrapper;
import com.fnproject.fn.api.exception.FunctionConfigurationException;
import com.fnproject.fn.runtime.FunctionRuntimeContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;

public class FunctionConfigurer {
    public void configure(FunctionRuntimeContext runtimeContext) {
        this.validateConfigurationMethods(runtimeContext.getMethodWrapper());
        this.applyUserConfigurationMethod(runtimeContext.getMethodWrapper(), runtimeContext);
    }

    private void validateConfigurationMethods(MethodWrapper function) {
        Arrays.stream(function.getTargetClass().getMethods()).filter(this::isConfigurationMethod).filter(m -> !m.getReturnType().equals(Void.TYPE)).forEach(m -> {
            throw new FunctionConfigurationException("Configuration method '" + m.getName() + "' does not have a void return type");
        });
        if (Modifier.isStatic(function.getTargetMethod().getModifiers())) {
            Arrays.stream(function.getTargetClass().getMethods()).filter(this::isConfigurationMethod).filter(m -> !Modifier.isStatic(m.getModifiers())).forEach(m -> {
                throw new FunctionConfigurationException("Configuration method '" + m.getName() + "' cannot be an instance method if the function method is a static method");
            });
        }
    }

    private void applyUserConfigurationMethod(MethodWrapper targetClass, FunctionRuntimeContext runtimeContext) {
        Arrays.stream(targetClass.getTargetClass().getMethods()).filter(this::isConfigurationMethod).sorted(Comparator.comparingInt(m -> Modifier.isStatic(m.getModifiers()) ? 0 : 1).thenComparing(Comparator.comparingInt(m -> {
            int depth = 0;
            for (Class<?> cc = m.getDeclaringClass(); null != cc; cc = cc.getSuperclass()) {
                ++depth;
            }
            return depth;
        }))).forEach(configMethod -> {
            try {
                Optional<Object> fnInstance = runtimeContext.getInvokeInstance();
                if (configMethod.getParameterCount() == 0) {
                    configMethod.invoke(fnInstance.orElse(null), new Object[0]);
                } else {
                    configMethod.invoke(fnInstance.orElse(null), runtimeContext);
                }
            }
            catch (InvocationTargetException e) {
                throw new FunctionConfigurationException("Error invoking configuration method: " + configMethod.getName(), e.getCause());
            }
            catch (IllegalAccessException e) {
                throw new FunctionConfigurationException("Error invoking configuration method: " + configMethod.getName(), (Throwable)e);
            }
        });
    }

    private boolean isConfigurationMethod(Method m) {
        return ((FnConfiguration[])m.getDeclaredAnnotationsByType(FnConfiguration.class)).length > 0 && !m.getDeclaringClass().isInterface();
    }
}

