/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime;

import com.fnproject.fn.api.FunctionInvoker;
import com.fnproject.fn.api.InputEvent;
import com.fnproject.fn.api.InvocationContext;
import com.fnproject.fn.api.MethodWrapper;
import com.fnproject.fn.api.OutputEvent;
import com.fnproject.fn.api.RuntimeContext;
import com.fnproject.fn.api.exception.FunctionInputHandlingException;
import com.fnproject.fn.api.exception.FunctionOutputHandlingException;
import com.fnproject.fn.runtime.FunctionRuntimeContext;
import com.fnproject.fn.runtime.exception.InternalFunctionInvocationException;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;

public class MethodFunctionInvoker
implements FunctionInvoker {
    public Optional<OutputEvent> tryInvoke(InvocationContext ctx, InputEvent evt) throws InternalFunctionInvocationException {
        Object rawResult;
        FunctionRuntimeContext runtimeContext = (FunctionRuntimeContext)ctx.getRuntimeContext();
        MethodWrapper method = runtimeContext.getMethodWrapper();
        Object[] userFunctionParams = this.coerceParameters(ctx, method, evt);
        try {
            rawResult = method.getTargetMethod().invoke(ctx.getRuntimeContext().getInvokeInstance().orElse(null), userFunctionParams);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InternalFunctionInvocationException(e.getCause().getMessage(), e.getCause());
        }
        return this.coerceReturnValue(ctx, method, rawResult);
    }

    protected Object[] coerceParameters(InvocationContext ctx, MethodWrapper targetMethod, InputEvent evt) {
        try {
            Object[] userFunctionParams = new Object[targetMethod.getParameterCount()];
            for (int paramIndex = 0; paramIndex < userFunctionParams.length; ++paramIndex) {
                userFunctionParams[paramIndex] = this.coerceParameter(ctx, targetMethod, paramIndex, evt);
            }
            return userFunctionParams;
        }
        catch (RuntimeException e) {
            throw new FunctionInputHandlingException("An exception was thrown during Input Coercion: " + e.getMessage(), (Throwable)e);
        }
    }

    private Object coerceParameter(InvocationContext ctx, MethodWrapper targetMethod, int param, InputEvent evt) {
        RuntimeContext runtimeContext = ctx.getRuntimeContext();
        return runtimeContext.getInputCoercions(targetMethod, param).stream().map(c -> c.tryCoerceParam(ctx, param, evt, targetMethod)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new FunctionInputHandlingException("No type coercion for argument " + param + " of " + targetMethod + " of found"));
    }

    protected Optional<OutputEvent> coerceReturnValue(InvocationContext ctx, MethodWrapper method, Object rawResult) {
        try {
            return Optional.of(ctx.getRuntimeContext().getOutputCoercions(method.getTargetMethod()).stream().map(c -> c.wrapFunctionResult(ctx, method, rawResult)).filter(Optional::isPresent).map(Optional::get).findFirst().orElseThrow(() -> new FunctionOutputHandlingException("No coercion found for return type")));
        }
        catch (RuntimeException e) {
            throw new FunctionOutputHandlingException("An exception was thrown during Output Coercion: " + e.getMessage(), (Exception)e);
        }
    }
}

