/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime;

import com.fnproject.fn.api.MethodWrapper;
import com.fnproject.fn.api.TypeWrapper;
import com.fnproject.fn.runtime.MethodTypeWrapper;
import java.lang.reflect.Method;
import java.util.Arrays;

public class DefaultMethodWrapper
implements MethodWrapper {
    private final Class<?> srcClass;
    private final Method srcMethod;

    DefaultMethodWrapper(Class<?> srcClass, Method srcMethod) {
        this.srcClass = srcClass;
        this.srcMethod = srcMethod;
    }

    DefaultMethodWrapper(Class<?> srcClass, String srcMethod) {
        this(srcClass, Arrays.stream(srcClass.getMethods()).filter(m -> m.getName().equals(srcMethod)).findFirst().orElseThrow(() -> new RuntimeException(new NoSuchMethodException(srcClass.getCanonicalName() + "::" + srcMethod))));
    }

    public Class<?> getTargetClass() {
        return this.srcClass;
    }

    public Method getTargetMethod() {
        return this.srcMethod;
    }

    public TypeWrapper getParamType(int index) {
        return MethodTypeWrapper.fromParameter(this, index);
    }

    public TypeWrapper getReturnType() {
        return MethodTypeWrapper.fromReturnType(this);
    }

    public String toString() {
        return this.getLongName();
    }
}

