/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime.coercion.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fnproject.fn.api.InputCoercion;
import com.fnproject.fn.api.InputEvent;
import com.fnproject.fn.api.InvocationContext;
import com.fnproject.fn.api.MethodWrapper;
import com.fnproject.fn.api.OutputCoercion;
import com.fnproject.fn.api.OutputEvent;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Optional;

public class JacksonCoercion
implements InputCoercion<Object>,
OutputCoercion {
    private static final String OM_KEY = JacksonCoercion.class.getCanonicalName() + ".om";
    private static final JacksonCoercion instance = new JacksonCoercion();

    public static JacksonCoercion instance() {
        return instance;
    }

    private static ObjectMapper objectMapper(InvocationContext ctx) {
        Optional omo = ctx.getRuntimeContext().getAttribute(OM_KEY, ObjectMapper.class);
        if (!omo.isPresent()) {
            ObjectMapper om = new ObjectMapper();
            ctx.getRuntimeContext().setAttribute(OM_KEY, (Object)om);
            return om;
        }
        return (ObjectMapper)omo.get();
    }

    public Optional<Object> tryCoerceParam(InvocationContext currentContext, int param, InputEvent input, MethodWrapper method) {
        Type type = method.getTargetMethod().getGenericParameterTypes()[param];
        JavaType javaType = JacksonCoercion.objectMapper(currentContext).constructType(type);
        return Optional.ofNullable(input.consumeBody(inputStream -> {
            try {
                return JacksonCoercion.objectMapper(currentContext).readValue(inputStream, javaType);
            }
            catch (IOException e) {
                throw JacksonCoercion.coercionFailed(type, e);
            }
        }));
    }

    private static RuntimeException coercionFailed(Type paramType, Throwable cause) {
        return new RuntimeException("Failed to coerce event to user function parameter type " + paramType, cause);
    }

    private static RuntimeException coercionFailed(Type paramType) {
        return JacksonCoercion.coercionFailed(paramType, null);
    }

    public Optional<OutputEvent> wrapFunctionResult(InvocationContext ctx, MethodWrapper method, Object value) {
        try {
            return Optional.of(OutputEvent.fromBytes((byte[])JacksonCoercion.objectMapper(ctx).writeValueAsBytes(value), (OutputEvent.Status)OutputEvent.Status.Success, (String)"application/json"));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to render response to JSON", e);
        }
    }
}

