/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime;

import com.fnproject.fn.api.Headers;
import com.fnproject.fn.api.InputEvent;
import com.fnproject.fn.api.InvocationContext;
import com.fnproject.fn.api.InvocationListener;
import com.fnproject.fn.runtime.FunctionInvocationCallback;
import com.fnproject.fn.runtime.FunctionRuntimeContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class FunctionInvocationContext
implements InvocationContext,
FunctionInvocationCallback {
    private final FunctionRuntimeContext runtimeContext;
    private final List<InvocationListener> invocationListeners = new CopyOnWriteArrayList<InvocationListener>();
    private final InputEvent event;
    private final Map<String, List<String>> additionalResponseHeaders = new ConcurrentHashMap<String, List<String>>();

    FunctionInvocationContext(FunctionRuntimeContext ctx, InputEvent event) {
        this.runtimeContext = ctx;
        this.event = event;
    }

    public FunctionRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public void addListener(InvocationListener listener) {
        this.invocationListeners.add(listener);
    }

    public Headers getRequestHeaders() {
        return this.event.getHeaders();
    }

    public void addResponseHeader(String key, String value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        this.additionalResponseHeaders.merge(key, Collections.singletonList(value), (a, b) -> {
            ArrayList l = new ArrayList(a);
            l.addAll(b);
            return l;
        });
    }

    Map<String, List<String>> getAdditionalResponseHeaders() {
        return this.additionalResponseHeaders;
    }

    public void setResponseHeader(String key, String value, String ... vs) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(vs, "vs");
        Arrays.stream(vs).forEach(v -> Objects.requireNonNull(v, "null value in list "));
        String cKey = Headers.canonicalKey((String)key);
        if (value == null) {
            this.additionalResponseHeaders.remove(cKey);
            return;
        }
        this.additionalResponseHeaders.put(cKey, Collections.singletonList(value));
    }

    @Override
    public void fireOnSuccessfulInvocation() {
        for (InvocationListener listener : this.invocationListeners) {
            try {
                listener.onSuccess();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void fireOnFailedInvocation() {
        for (InvocationListener listener : this.invocationListeners) {
            try {
                listener.onFailure();
            }
            catch (Exception exception) {}
        }
    }
}

