/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime;

import com.fnproject.fn.api.FunctionInvoker;
import com.fnproject.fn.api.InputBinding;
import com.fnproject.fn.api.InputCoercion;
import com.fnproject.fn.api.InputEvent;
import com.fnproject.fn.api.InvocationContext;
import com.fnproject.fn.api.MethodWrapper;
import com.fnproject.fn.api.OutputBinding;
import com.fnproject.fn.api.OutputCoercion;
import com.fnproject.fn.api.OutputEvent;
import com.fnproject.fn.api.RuntimeContext;
import com.fnproject.fn.api.exception.FunctionConfigurationException;
import com.fnproject.fn.api.exception.FunctionInputHandlingException;
import com.fnproject.fn.runtime.FunctionInvocationContext;
import com.fnproject.fn.runtime.MethodFunctionInvoker;
import com.fnproject.fn.runtime.coercion.ByteArrayCoercion;
import com.fnproject.fn.runtime.coercion.ContextCoercion;
import com.fnproject.fn.runtime.coercion.InputEventCoercion;
import com.fnproject.fn.runtime.coercion.OutputEventCoercion;
import com.fnproject.fn.runtime.coercion.StringCoercion;
import com.fnproject.fn.runtime.coercion.VoidCoercion;
import com.fnproject.fn.runtime.coercion.jackson.JacksonCoercion;
import com.fnproject.fn.runtime.exception.FunctionClassInstantiationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class FunctionRuntimeContext
implements RuntimeContext {
    private final Map<String, String> config;
    private final MethodWrapper method;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final List<FunctionInvoker> preCallHandlers = new ArrayList<FunctionInvoker>();
    private final List<FunctionInvoker> configuredInvokers = new ArrayList<FunctionInvoker>();
    private Object instance;
    private final List<InputCoercion> builtinInputCoercions = Arrays.asList(new ContextCoercion(), new StringCoercion(), new ByteArrayCoercion(), new InputEventCoercion(), JacksonCoercion.instance());
    private final List<InputCoercion> userInputCoercions = new LinkedList<InputCoercion>();
    private final List<OutputCoercion> builtinOutputCoercions = Arrays.asList(new StringCoercion(), new ByteArrayCoercion(), new VoidCoercion(), new OutputEventCoercion(), JacksonCoercion.instance());
    private final List<OutputCoercion> userOutputCoercions = new LinkedList<OutputCoercion>();

    public FunctionRuntimeContext(MethodWrapper method, Map<String, String> config) {
        this.method = method;
        this.config = Objects.requireNonNull(config);
        this.configuredInvokers.add(new MethodFunctionInvoker());
    }

    public String getAppID() {
        return this.config.getOrDefault("FN_APP_ID", "");
    }

    public String getFunctionID() {
        return this.config.getOrDefault("FN_FN_ID", "");
    }

    public String getAppName() {
        return this.config.getOrDefault("FN_APP_NAME", "");
    }

    public String getFunctionName() {
        return this.config.getOrDefault("FN_FN_NAME", "");
    }

    public Optional<Object> getInvokeInstance() {
        if (!Modifier.isStatic(this.getMethod().getTargetMethod().getModifiers())) {
            block11: {
                if (this.instance == null) {
                    try {
                        Constructor<?>[] constructors = this.getMethod().getTargetClass().getConstructors();
                        if (constructors.length == 1) {
                            Constructor<?> ctor = constructors[0];
                            if (ctor.getParameterTypes().length == 0) {
                                this.instance = ctor.newInstance(new Object[0]);
                                break block11;
                            }
                            if (ctor.getParameterTypes().length == 1) {
                                if (RuntimeContext.class.isAssignableFrom(ctor.getParameterTypes()[0])) {
                                    this.instance = ctor.newInstance(this);
                                    break block11;
                                }
                                if (this.getMethod().getTargetClass().getEnclosingClass() != null && !Modifier.isStatic(this.getMethod().getTargetClass().getModifiers())) {
                                    throw new FunctionClassInstantiationException("The function " + this.getMethod().getTargetClass() + " cannot be instantiated as it is a non-static inner class");
                                }
                                throw new FunctionClassInstantiationException("The function " + this.getMethod().getTargetClass() + " cannot be instantiated as its constructor takes an unrecognized argument of type " + constructors[0].getParameterTypes()[0] + ". Function classes should have a single public constructor that takes either no arguments or a RuntimeContext argument");
                            }
                            throw new FunctionClassInstantiationException("The function " + this.getMethod().getTargetClass() + " cannot be instantiated as its constructor takes more than one argument. Function classes should have a single public constructor that takes either no arguments or a RuntimeContext argument");
                        }
                        if (constructors.length == 0) {
                            throw new FunctionClassInstantiationException("The function " + this.getMethod().getTargetClass() + " cannot be instantiated as it has no public constructors. Function classes should have a single public constructor that takes either no arguments or a RuntimeContext argument");
                        }
                        throw new FunctionClassInstantiationException("The function " + this.getMethod().getTargetClass() + " cannot be instantiated as it has multiple public constructors. Function classes should have a single public constructor that takes either no arguments or a RuntimeContext argument");
                    }
                    catch (InvocationTargetException e) {
                        throw new FunctionClassInstantiationException("An error occurred in the function constructor while instantiating " + this.getMethod().getTargetClass(), e.getCause());
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new FunctionClassInstantiationException("The function class " + this.getMethod().getTargetClass() + " could not be instantiated", e);
                    }
                }
            }
            return Optional.of(this.instance);
        }
        return Optional.empty();
    }

    public Optional<String> getConfigurationByKey(String key) {
        return Optional.ofNullable(this.config.get(key));
    }

    public Map<String, String> getConfiguration() {
        return this.config;
    }

    public <T> Optional<T> getAttribute(String att, Class<T> type) {
        Objects.requireNonNull(att);
        Objects.requireNonNull(type);
        return Optional.ofNullable(type.cast(this.attributes.get(att)));
    }

    public void setAttribute(String att, Object val) {
        Objects.requireNonNull(att);
        this.attributes.put(att, val);
    }

    public void addInputCoercion(InputCoercion ic) {
        this.userInputCoercions.add(Objects.requireNonNull(ic));
    }

    public List<InputCoercion> getInputCoercions(MethodWrapper targetMethod, int param) {
        Annotation[] parameterAnnotations = targetMethod.getTargetMethod().getParameterAnnotations()[param];
        Optional<Annotation> coercionAnnotation = Arrays.stream(parameterAnnotations).filter(ann -> ann.annotationType().equals(InputBinding.class)).findFirst();
        if (coercionAnnotation.isPresent()) {
            try {
                ArrayList<InputCoercion> coercionList = new ArrayList<InputCoercion>();
                InputBinding inputBindingAnnotation = (InputBinding)coercionAnnotation.get();
                coercionList.add((InputCoercion)inputBindingAnnotation.coercion().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                return coercionList;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new FunctionInputHandlingException("Unable to instantiate input coercion class for argument " + param + " of " + targetMethod);
            }
        }
        ArrayList<InputCoercion> inputList = new ArrayList<InputCoercion>();
        inputList.addAll(this.userInputCoercions);
        inputList.addAll(this.builtinInputCoercions);
        return inputList;
    }

    public void addOutputCoercion(OutputCoercion oc) {
        this.userOutputCoercions.add(Objects.requireNonNull(oc));
    }

    public void addInvoker(FunctionInvoker invoker, FunctionInvoker.Phase phase) {
        switch (phase) {
            case PreCall: {
                this.preCallHandlers.add(0, invoker);
                break;
            }
            case Call: {
                this.configuredInvokers.add(0, invoker);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported phase " + phase);
            }
        }
    }

    public MethodWrapper getMethod() {
        return this.method;
    }

    public FunctionInvocationContext newInvocationContext(InputEvent inputEvent) {
        return new FunctionInvocationContext(this, inputEvent);
    }

    public OutputEvent tryInvoke(InputEvent evt, InvocationContext entryPoint) {
        Optional result;
        for (FunctionInvoker invoker : this.preCallHandlers) {
            result = invoker.tryInvoke(entryPoint, evt);
            if (!result.isPresent()) continue;
            return (OutputEvent)result.get();
        }
        for (FunctionInvoker invoker : this.configuredInvokers) {
            result = invoker.tryInvoke(entryPoint, evt);
            if (!result.isPresent()) continue;
            return (OutputEvent)result.get();
        }
        return null;
    }

    public List<OutputCoercion> getOutputCoercions(Method method) {
        OutputBinding coercionAnnotation = method.getAnnotation(OutputBinding.class);
        if (coercionAnnotation != null) {
            try {
                ArrayList<OutputCoercion> coercionList = new ArrayList<OutputCoercion>();
                coercionList.add((OutputCoercion)coercionAnnotation.coercion().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                return coercionList;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new FunctionConfigurationException("Unable to instantiate output coercion class for method " + this.getMethod());
            }
        }
        ArrayList<OutputCoercion> outputList = new ArrayList<OutputCoercion>();
        outputList.addAll(this.userOutputCoercions);
        outputList.addAll(this.builtinOutputCoercions);
        return outputList;
    }

    public MethodWrapper getMethodWrapper() {
        return this.method;
    }
}

