/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime.coercion;

import com.fnproject.fn.api.InputCoercion;
import com.fnproject.fn.api.InputEvent;
import com.fnproject.fn.api.InvocationContext;
import com.fnproject.fn.api.MethodWrapper;
import com.fnproject.fn.api.OutputCoercion;
import com.fnproject.fn.api.OutputEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;

public class ByteArrayCoercion
implements InputCoercion<byte[]>,
OutputCoercion {
    public Optional<OutputEvent> wrapFunctionResult(InvocationContext ctx, MethodWrapper method, Object value) {
        if (method.getReturnType().getParameterClass().equals(byte[].class)) {
            return Optional.of(OutputEvent.fromBytes((byte[])((byte[])value), (OutputEvent.Status)OutputEvent.Status.Success, (String)"application/octet-stream"));
        }
        return Optional.empty();
    }

    private byte[] toByteArray(InputStream is) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        while ((nRead = is.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public Optional<byte[]> tryCoerceParam(InvocationContext currentContext, int arg, InputEvent input, MethodWrapper method) {
        if (method.getParamType(arg).getParameterClass().equals(byte[].class)) {
            return Optional.of((byte[])input.consumeBody(is -> {
                try {
                    return this.toByteArray((InputStream)is);
                }
                catch (IOException e) {
                    throw new RuntimeException("Error reading input as bytes", e);
                }
            }));
        }
        return Optional.empty();
    }
}

