/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime.httpgateway;

import com.fnproject.fn.api.QueryParameters;
import com.fnproject.fn.runtime.httpgateway.QueryParametersImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QueryParametersParser {
    public static QueryParameters getParams(String url) {
        int beginIndex = url.indexOf("?");
        if (beginIndex < 0) {
            return new QueryParametersImpl();
        }
        String queryParameters = url.substring(beginIndex + 1);
        return new QueryParametersImpl(QueryParametersParser.parseQueryParameters(queryParameters));
    }

    private static Map<String, List<String>> parseQueryParameters(String queryParameters) {
        if (queryParameters == null || "".equals(queryParameters)) {
            return Collections.emptyMap();
        }
        return Arrays.stream(queryParameters.split("[&;]")).map(QueryParametersParser::splitQueryParameter).collect(Collectors.groupingBy(Map.Entry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private static Map.Entry<String, String> splitQueryParameter(String parameter) {
        int idx = parameter.indexOf("=");
        String key = QueryParametersParser.decode(idx > 0 ? parameter.substring(0, idx) : parameter);
        String value = idx > 0 && parameter.length() > idx + 1 ? QueryParametersParser.decode(parameter.substring(idx + 1)) : "";
        return new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
    }

    private static String decode(String urlEncodedString) {
        try {
            return URLDecoder.decode(urlEncodedString, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("No utf-8 support in underlying platform", e);
        }
    }
}

