/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime;

import com.fasterxml.jackson.core.io.CharTypes;
import com.fnproject.fn.api.Headers;
import com.fnproject.fn.api.InputEvent;
import com.fnproject.fn.api.OutputEvent;
import com.fnproject.fn.api.exception.FunctionInputHandlingException;
import com.fnproject.fn.api.exception.FunctionOutputHandlingException;
import com.fnproject.fn.runtime.EventCodec;
import com.fnproject.fn.runtime.ReadOnceInputEvent;
import com.fnproject.fn.runtime.exception.FunctionInitializationException;
import com.fnproject.fn.runtime.ntv.UnixServerSocket;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ParseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.io.EmptyInputStream;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.protocol.HttpContext;

public final class HTTPStreamCodec
implements EventCodec,
Closeable {
    public static final String HTTP_STREAM_FORMAT = "http-stream";
    private static final String FN_LISTENER = "FN_LISTENER";
    private static final Set<String> stripInputHeaders;
    private static final Set<String> stripOutputHeaders;
    private final Map<String, String> env;
    private final String fdkVersion;
    private final String runtimeVersion;
    private final AtomicBoolean stopping = new AtomicBoolean(false);
    private final File socketFile;
    private final CompletableFuture<Boolean> stopped = new CompletableFuture();
    private final UnixServerSocket socket;
    private final File tempFile;

    private String randomString() {
        int leftLimit = 97;
        int rightLimit = 122;
        int targetStringLength = 10;
        Random random = new Random();
        StringBuilder buffer = new StringBuilder(targetStringLength);
        for (int i = 0; i < targetStringLength; ++i) {
            int randomLimitedInt = leftLimit + (int)(random.nextFloat() * (float)(rightLimit - leftLimit + 1));
            buffer.append((char)randomLimitedInt);
        }
        return buffer.toString();
    }

    HTTPStreamCodec(Map<String, String> env, String fdkVersion, String runtimeVersion) {
        this.env = Objects.requireNonNull(env, "env");
        this.fdkVersion = Objects.requireNonNull(fdkVersion, "fdkVersion");
        this.runtimeVersion = Objects.requireNonNull(runtimeVersion, "runtimeVersion");
        String listenerAddress = this.getRequiredEnv(FN_LISTENER);
        if (!listenerAddress.startsWith("unix:/")) {
            throw new FunctionInitializationException("Invalid listener address - it should start with unix:/ :'" + listenerAddress + "'");
        }
        String listenerFile = listenerAddress.substring("unix:".length());
        this.socketFile = new File(listenerFile);
        UnixServerSocket serverSocket = null;
        File listenerDir = this.socketFile.getParentFile();
        this.tempFile = new File(listenerDir, this.randomString() + ".sock");
        try {
            serverSocket = UnixServerSocket.listen(this.tempFile.getAbsolutePath(), 1);
            Files.setPosixFilePermissions(this.tempFile.toPath(), PosixFilePermissions.fromString("rw-rw-rw-"));
            Files.createSymbolicLink(this.socketFile.toPath(), this.tempFile.toPath().getFileName(), new FileAttribute[0]);
            this.socket = serverSocket;
        }
        catch (IOException e) {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new FunctionInitializationException("Unable to bind to unix socket in " + this.socketFile, e);
        }
    }

    private String jsonError(String message, String detail) {
        if (message == null) {
            message = "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{ \"message\":\"");
        CharTypes.appendQuoted((StringBuilder)sb, (String)message);
        sb.append("\"");
        if (detail != null) {
            sb.append(", \"detail\":\"");
            CharTypes.appendQuoted((StringBuilder)sb, (String)detail);
            sb.append("\"");
        }
        sb.append("}");
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void runCodec(EventCodec.Handler h) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getRequiredEnv(String name) {
        String val = this.env.get(name);
        if (val == null) {
            throw new FunctionInputHandlingException("Required environment variable " + name + " is not set - are you running a function outside of fn run?");
        }
        return val;
    }

    private static String getRequiredHeader(HttpRequest request, String headerName) {
        Header header = request.getFirstHeader(headerName);
        if (header == null) {
            throw new FunctionInputHandlingException("Required FDK header variable " + headerName + " is not set, check you are using the latest fn and FDK versions");
        }
        return header.getValue();
    }

    private InputEvent readEvent(HttpRequest request) {
        Object bodyStream;
        if (request instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)request;
            try {
                bodyStream = entityEnclosingRequest.getEntity().getContent();
            }
            catch (IOException exception) {
                throw new FunctionInputHandlingException("error handling input", (Throwable)exception);
            }
        } else {
            bodyStream = EmptyInputStream.INSTANCE;
        }
        String deadline = HTTPStreamCodec.getRequiredHeader(request, "Fn-Deadline");
        String callID = HTTPStreamCodec.getRequiredHeader(request, "Fn-Call-Id");
        if (callID == null) {
            callID = "";
        }
        Instant deadlineDate = Instant.now().plus(1L, ChronoUnit.HOURS);
        if (deadline != null) {
            try {
                deadlineDate = Instant.parse(deadline);
            }
            catch (DateTimeParseException e) {
                throw new FunctionInputHandlingException("Invalid deadline date format", (Throwable)e);
            }
        }
        Headers headersIn = Headers.emptyHeaders();
        for (Header h : request.getAllHeaders()) {
            if (stripInputHeaders.contains(Headers.canonicalKey((String)h.getName()))) continue;
            headersIn = headersIn.addHeader(h.getName(), h.getValue(), new String[0]);
        }
        return new ReadOnceInputEvent((InputStream)bodyStream, headersIn, callID, deadlineDate);
    }

    private void writeEvent(OutputEvent evt, HttpResponse response) {
        evt.getHeaders().asMap().entrySet().stream().filter(e -> !stripOutputHeaders.contains(e.getKey())).flatMap(e -> ((List)e.getValue()).stream().map(v -> new BasicHeader((String)e.getKey(), v))).forEachOrdered(arg_0 -> ((HttpResponse)response).addHeader(arg_0));
        ContentType contentType = evt.getContentType().map(c -> {
            try {
                return ContentType.parse((String)c);
            }
            catch (ParseException e) {
                return ContentType.DEFAULT_BINARY;
            }
        }).orElse(ContentType.DEFAULT_BINARY);
        response.setHeader("Content-Type", contentType.toString());
        response.setHeader("Fn-Fdk-Version", this.fdkVersion);
        response.setHeader("Fn-Fdk-Runtime", this.runtimeVersion);
        response.setStatusLine((StatusLine)new BasicStatusLine((ProtocolVersion)HttpVersion.HTTP_1_1, evt.getStatus().getCode(), evt.getStatus().name()));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            evt.writeToOutput((OutputStream)bos);
        }
        catch (IOException e2) {
            throw new FunctionOutputHandlingException("Error writing output", (Exception)e2);
        }
        byte[] data = bos.toByteArray();
        response.setEntity((HttpEntity)new ByteArrayEntity(data, contentType));
    }

    @Override
    public void close() throws IOException {
        if (this.stopping.compareAndSet(false, true)) {
            this.socket.close();
            try {
                this.stopped.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socketFile.delete();
            this.tempFile.delete();
        }
    }

    private /* synthetic */ void lambda$runCodec$0(EventCodec.Handler h, HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        OutputEvent outEvt;
        InputEvent evt;
        try {
            evt = this.readEvent(request);
        }
        catch (FunctionInputHandlingException e) {
            response.setStatusCode(500);
            response.setEntity((HttpEntity)new StringEntity(this.jsonError("Invalid input for function", e.getMessage()), ContentType.APPLICATION_JSON));
            return;
        }
        try {
            outEvt = h.handle(evt);
        }
        catch (Exception e) {
            response.setStatusCode(500);
            response.setEntity((HttpEntity)new StringEntity(this.jsonError("Unhandled internal error in FDK", e.getMessage()), ContentType.APPLICATION_JSON));
            return;
        }
        try {
            this.writeEvent(outEvt, response);
        }
        catch (Exception e) {
            response.setStatusCode(500);
            response.setEntity((HttpEntity)new StringEntity(this.jsonError("Unhandled internal error while writing FDK response", e.getMessage()), ContentType.APPLICATION_JSON));
        }
    }

    static {
        HashSet<String> hin = new HashSet<String>();
        hin.add("Host");
        hin.add("Accept-Encoding");
        hin.add("Transfer-Encoding");
        hin.add("User-Agent");
        hin.add("Connection");
        hin.add("TE");
        stripInputHeaders = Collections.unmodifiableSet(hin);
        HashSet<String> hout = new HashSet<String>();
        hout.add("Content-Length");
        hout.add("Transfer-Encoding");
        hout.add("Connection");
        hout.add("Fn-Fdk-Version");
        stripOutputHeaders = Collections.unmodifiableSet(hout);
    }
}

