/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime;

import com.fnproject.fn.api.FnFeature;
import com.fnproject.fn.api.FnFeatures;
import com.fnproject.fn.api.InputEvent;
import com.fnproject.fn.api.MethodWrapper;
import com.fnproject.fn.api.OutputEvent;
import com.fnproject.fn.api.RuntimeContext;
import com.fnproject.fn.api.RuntimeFeature;
import com.fnproject.fn.api.exception.FunctionInputHandlingException;
import com.fnproject.fn.api.exception.FunctionLoadException;
import com.fnproject.fn.api.exception.FunctionOutputHandlingException;
import com.fnproject.fn.runtime.EventCodec;
import com.fnproject.fn.runtime.FunctionConfigurer;
import com.fnproject.fn.runtime.FunctionInvocationContext;
import com.fnproject.fn.runtime.FunctionLoader;
import com.fnproject.fn.runtime.FunctionRuntimeContext;
import com.fnproject.fn.runtime.HTTPStreamCodec;
import com.fnproject.fn.runtime.exception.FunctionInitializationException;
import com.fnproject.fn.runtime.exception.InternalFunctionInvocationException;
import com.fnproject.fn.runtime.exception.InvalidEntryPointException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class EntryPoint {
    private static final Pattern safeVersion = Pattern.compile("[^\\w ()._-]+");

    public static void main(String ... args) {
        PrintStream originalSystemOut = System.out;
        System.setOut(System.err);
        String format = System.getenv("FN_FORMAT");
        if (!format.equals("http-stream")) {
            throw new FunctionInputHandlingException("Unsupported function format:" + format);
        }
        String jvmName = safeVersion.matcher(System.getProperty("java.vm.name")).replaceAll("");
        String jvmVersion = safeVersion.matcher(System.getProperty("java.version")).replaceAll("");
        String fdkVersion = "fdk-java/1.0.209 (jvm=" + jvmName + ", jvmv=" + jvmVersion + ")";
        String runtimeVersion = "java/" + jvmName + " " + jvmVersion;
        HTTPStreamCodec codec = new HTTPStreamCodec(System.getenv(), fdkVersion, runtimeVersion);
        int exitCode = new EntryPoint().run(System.getenv(), codec, System.err, args);
        System.setOut(originalSystemOut);
        System.exit(exitCode);
    }

    private Consumer<InputEvent> logFramer(Map<String, String> config) {
        String valueSrc;
        String framer = config.getOrDefault("FN_LOGFRAME_NAME", "");
        if (!framer.isEmpty() && !(valueSrc = config.getOrDefault("FN_LOGFRAME_HDR", "")).isEmpty()) {
            return evt -> {
                String id = evt.getHeaders().get(valueSrc).orElse("");
                if (!id.isEmpty()) {
                    System.out.println("\n" + framer + "=" + id + "\n");
                    System.err.println("\n" + framer + "=" + id + "\n");
                }
            };
        }
        return event -> {};
    }

    public int run(Map<String, String> env, EventCodec codec, final PrintStream loggingOutput, String ... args) {
        if (args.length != 1) {
            throw new InvalidEntryPointException("Expected one argument, of the form com.company.project.MyFunctionClass::myFunctionMethod");
        }
        String[] classMethod = args[0].split("::");
        if (classMethod.length != 2) {
            throw new InvalidEntryPointException("Entry point is malformed expecting a string of the form com.company.project.MyFunctionClass::myFunctionMethod");
        }
        final String cls = classMethod[0];
        final String mth = classMethod[1];
        final AtomicInteger lastStatus = new AtomicInteger();
        try {
            final Map<String, String> configFromEnvVars = Collections.unmodifiableMap(this.excludeInternalConfigAndHeaders(env));
            final Consumer<InputEvent> logFramer = this.logFramer(configFromEnvVars);
            codec.runCodec(new EventCodec.Handler(){
                FunctionRuntimeContext _runtimeContext;

                private FunctionRuntimeContext getRuntimeContext() {
                    if (this._runtimeContext == null) {
                        FnFeatures fs;
                        FunctionLoader functionLoader = new FunctionLoader();
                        MethodWrapper method = functionLoader.loadClass(cls, mth);
                        FunctionRuntimeContext runtimeContext = new FunctionRuntimeContext(method, configFromEnvVars);
                        FnFeature f = method.getTargetClass().getAnnotation(FnFeature.class);
                        if (f != null) {
                            EntryPoint.this.enableFeature(runtimeContext, f);
                        }
                        if ((fs = method.getTargetClass().getAnnotation(FnFeatures.class)) != null) {
                            for (FnFeature fnFeature : fs.value()) {
                                EntryPoint.this.enableFeature(runtimeContext, fnFeature);
                            }
                        }
                        FunctionConfigurer functionConfigurer = new FunctionConfigurer();
                        functionConfigurer.configure(runtimeContext);
                        this._runtimeContext = runtimeContext;
                    }
                    return this._runtimeContext;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public OutputEvent handle(InputEvent evt) {
                    try {
                        logFramer.accept(evt);
                        FunctionRuntimeContext runtimeContext = this.getRuntimeContext();
                        FunctionInvocationContext fic = runtimeContext.newInvocationContext(evt);
                        try (InputEvent myEvt = evt;){
                            OutputEvent output = runtimeContext.tryInvoke(evt, fic);
                            if (output == null) {
                                throw new FunctionInputHandlingException("No invoker found for input event");
                            }
                            if (output.isSuccess()) {
                                lastStatus.set(0);
                                fic.fireOnSuccessfulInvocation();
                            } else {
                                lastStatus.set(1);
                                fic.fireOnFailedInvocation();
                            }
                            OutputEvent outputEvent = output.withHeaders(output.getHeaders().setHeaders(fic.getAdditionalResponseHeaders()));
                            return outputEvent;
                        }
                        catch (IOException err) {
                            fic.fireOnFailedInvocation();
                            throw new FunctionInputHandlingException("Error closing function input", (Throwable)err);
                        }
                        catch (Exception e) {
                            fic.fireOnFailedInvocation();
                            throw e;
                        }
                    }
                    catch (InternalFunctionInvocationException fie) {
                        loggingOutput.println("An error occurred in function: " + EntryPoint.this.filterStackTraceToOnlyIncludeUsersCode(fie));
                        loggingOutput.flush();
                        lastStatus.set(fie.toOutput().isSuccess() ? 0 : 1);
                        return fie.toOutput();
                    }
                    catch (FunctionInputHandlingException | FunctionLoadException | FunctionOutputHandlingException e) {
                        loggingOutput.println(EntryPoint.this.filterStackTraceToOnlyIncludeUsersCode(e));
                        loggingOutput.flush();
                        lastStatus.set(2);
                        return new InternalFunctionInvocationException("Error initializing function", e).toOutput();
                    }
                }
            });
        }
        catch (Exception ee) {
            loggingOutput.println("An unexpected error occurred:");
            ee.printStackTrace(loggingOutput);
            return 1;
        }
        return lastStatus.get();
    }

    private void enableFeature(FunctionRuntimeContext runtimeContext, FnFeature f) {
        RuntimeFeature rf;
        try {
            Class featureClass = f.value();
            rf = (RuntimeFeature)featureClass.newInstance();
        }
        catch (Exception e) {
            throw new FunctionInitializationException("Could not load feature class " + f.value().toString(), e);
        }
        try {
            rf.initialize((RuntimeContext)runtimeContext);
        }
        catch (Exception e) {
            throw new FunctionInitializationException("Exception while calling initialization on runtime feature " + f.value(), e);
        }
    }

    private String filterStackTraceToOnlyIncludeUsersCode(Throwable t) {
        StringBuilder sb = new StringBuilder();
        for (Throwable current = t; current != null; current = current.getCause()) {
            this.addExceptionToStringBuilder(sb, current);
        }
        return sb.toString();
    }

    private void addExceptionToStringBuilder(StringBuilder sb, Throwable t) {
        if (t.toString().startsWith("com.fnproject.fn")) {
            sb.append(t.getMessage());
        } else {
            sb.append("Caused by: ").append(t.toString());
        }
        for (StackTraceElement elem : t.getStackTrace()) {
            if (elem.getClassName().startsWith("com.fnproject.fn")) break;
            sb.append("\n    at ").append(elem.toString());
        }
        sb.append("\n");
    }

    private Map<String, String> excludeInternalConfigAndHeaders(Map<String, String> env) {
        HashSet<String> nonConfigEnvKeys = new HashSet<String>(Arrays.asList("fn_path", "fn_method", "fn_request_url", "fn_format", "content-length", "fn_call_id"));
        HashMap<String, String> config = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String lowerCaseKey = entry.getKey().toLowerCase();
            if (lowerCaseKey.startsWith("header_") || nonConfigEnvKeys.contains(lowerCaseKey)) continue;
            config.put(entry.getKey(), entry.getValue());
        }
        return config;
    }
}

