/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime;

import com.fnproject.fn.api.MethodWrapper;
import com.fnproject.fn.api.TypeWrapper;
import com.fnproject.fn.runtime.PrimitiveTypeResolver;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import net.jodah.typetools.TypeResolver;

public final class MethodTypeWrapper
implements TypeWrapper {
    private final Class<?> parameterClass;

    private MethodTypeWrapper(Class<?> parameterClass) {
        this.parameterClass = parameterClass;
    }

    public Class<?> getParameterClass() {
        return this.parameterClass;
    }

    static Class<?> resolveType(Type type, MethodWrapper src) {
        if (type instanceof Class) {
            return PrimitiveTypeResolver.resolve((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        Class resolvedType = TypeResolver.resolveRawArgument((Type)type, (Class)src.getTargetClass());
        if (resolvedType == TypeResolver.Unknown.class) {
            throw new RuntimeException("Cannot infer type of method parameter");
        }
        return resolvedType;
    }

    public static TypeWrapper fromParameter(MethodWrapper method, int paramIndex) {
        return new MethodTypeWrapper(MethodTypeWrapper.resolveType(method.getTargetMethod().getGenericParameterTypes()[paramIndex], method));
    }

    public static TypeWrapper fromReturnType(MethodWrapper method) {
        return new MethodTypeWrapper(MethodTypeWrapper.resolveType(method.getTargetMethod().getGenericReturnType(), method));
    }
}

