/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime;

import com.fnproject.fn.api.Headers;
import com.fnproject.fn.api.InputEvent;
import com.fnproject.fn.api.exception.FunctionInputHandlingException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class ReadOnceInputEvent
implements InputEvent {
    private final BufferedInputStream body;
    private final AtomicBoolean consumed = new AtomicBoolean(false);
    private final Headers headers;
    private final Instant deadline;
    private final String callID;

    public ReadOnceInputEvent(InputStream body, Headers headers, String callID, Instant deadline) {
        this.body = new BufferedInputStream(Objects.requireNonNull(body, "body"));
        this.headers = Objects.requireNonNull(headers, "headers");
        this.callID = Objects.requireNonNull(callID, "callID");
        this.deadline = Objects.requireNonNull(deadline, "deadline");
        body.mark(Integer.MAX_VALUE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T consumeBody(Function<InputStream, T> dest) {
        if (!this.consumed.compareAndSet(false, true)) throw new IllegalStateException("Body has already been consumed");
        try (BufferedInputStream rb = this.body;){
            InputStream inputStream = dest.apply(rb);
            return (T)inputStream;
        }
        catch (IOException e) {
            throw new FunctionInputHandlingException("Error reading input stream", (Throwable)e);
        }
    }

    public String getCallID() {
        return this.callID;
    }

    public Instant getDeadline() {
        return this.deadline;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public void close() throws IOException {
        this.body.close();
    }
}

