/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime.ntv;

import com.fnproject.fn.runtime.ntv.UnixSocketException;
import com.fnproject.fn.runtime.ntv.UnixSocketNative;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class UnixSocket
extends Socket {
    private static final SocketImpl fakeSocketImpl = new SocketImpl(){

        @Override
        protected void create(boolean stream) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void connect(String host, int port) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void connect(InetAddress address, int port) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void connect(SocketAddress address, int timeout) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void bind(InetAddress host, int port) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void listen(int backlog) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void accept(SocketImpl s) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int available() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void close() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void sendUrgentData(int data) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setOption(int optID, Object value) throws SocketException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object getOption(int optID) throws SocketException {
            throw new UnsupportedOperationException();
        }
    };
    private final int fd;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean inputClosed = new AtomicBoolean();
    private final AtomicBoolean outputClosed = new AtomicBoolean();
    private final InputStream in;
    private final OutputStream out;

    UnixSocket(int fd) throws SocketException {
        super(fakeSocketImpl);
        this.fd = fd;
        this.in = new UsInput();
        this.out = new UsOutput();
    }

    public static UnixSocket connect(String destination) throws IOException {
        int fd = UnixSocketNative.socket();
        UnixSocketNative.connect(fd, destination);
        return new UnixSocket(fd);
    }

    @Override
    public InputStream getInputStream() {
        return this.in;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        UnixSocketNative.setRecvBufSize(this.fd, size);
    }

    @Override
    public synchronized void setSendBufferSize(int size) throws SocketException {
        UnixSocketNative.setSendBufSize(this.fd, size);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        UnixSocketNative.setRecvTimeout(this.fd, timeout);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return UnixSocketNative.getRecvTimeout(this.fd);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InetAddress getInetAddress() {
        return null;
    }

    @Override
    public InetAddress getLocalAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPort() {
        return 0;
    }

    @Override
    public int getLocalPort() {
        return -1;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return null;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return null;
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public boolean isBound() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public boolean isInputShutdown() {
        return this.inputClosed.get();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.outputClosed.get();
    }

    @Override
    public void shutdownInput() throws IOException {
        if (!this.inputClosed.compareAndSet(false, true)) {
            throw new SocketException("Input already shut down");
        }
        UnixSocketNative.shutdown(this.fd, true, false);
    }

    @Override
    public void shutdownOutput() throws IOException {
        if (!this.outputClosed.compareAndSet(false, true)) {
            throw new SocketException("Output already shut down");
        }
        UnixSocketNative.shutdown(this.fd, false, true);
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            UnixSocketNative.close(this.fd);
        }
    }

    private class UsOutput
    extends OutputStream {
        private UsOutput() {
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (UnixSocket.this.outputClosed.get()) {
                throw new UnixSocketException("Write to closed stream");
            }
            Objects.requireNonNull(b);
            while (len > 0) {
                int sent = UnixSocketNative.send(UnixSocket.this.fd, b, off, len);
                if (sent == 0) {
                    throw new UnixSocketException("No data written to buffer");
                }
                off += sent;
                len -= sent;
            }
        }

        @Override
        public void close() throws IOException {
            UnixSocket.this.shutdownOutput();
        }
    }

    private class UsInput
    extends InputStream {
        private UsInput() {
        }

        @Override
        public int read() throws IOException {
            byte[] buf = new byte[1];
            int rv = this.read(buf, 0, 1);
            if (rv == -1) {
                return -1;
            }
            return buf[0];
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (UnixSocket.this.inputClosed.get()) {
                throw new UnixSocketException("Read on closed stream");
            }
            return UnixSocketNative.recv(UnixSocket.this.fd, b, off, len);
        }

        @Override
        public void close() throws IOException {
            UnixSocket.this.shutdownInput();
        }
    }
}

