/*
 * Decompiled with CFR 0.152.
 */
package com.fnproject.fn.runtime.tracing;

import com.fnproject.fn.api.Headers;
import com.fnproject.fn.api.InvocationContext;
import com.fnproject.fn.api.RuntimeContext;
import com.fnproject.fn.api.tracing.TracingContext;

public class OCITracingContext
implements TracingContext {
    private final InvocationContext invocationContext;
    private final RuntimeContext runtimeContext;
    private String traceCollectorURL;
    private String traceId;
    private String spanId;
    private String parentSpanId;
    private Boolean sampled = true;
    private String flags;
    private Boolean tracingEnabled;
    private String appName;
    private String fnName;
    private static final String PLACEHOLDER_TRACE_COLLECTOR_URL = "http://localhost:9411/api/v2/span";
    private static final String PLACEHOLDER_TRACE_ID = "1";

    public OCITracingContext(InvocationContext invocationContext, RuntimeContext runtimeContext) {
        this.invocationContext = invocationContext;
        this.runtimeContext = runtimeContext;
        this.configureDefaultValue();
        this.configure(runtimeContext);
        if (this.tracingEnabled.booleanValue()) {
            this.configure(invocationContext.getRequestHeaders());
        }
    }

    private void configureDefaultValue() {
        this.traceCollectorURL = PLACEHOLDER_TRACE_COLLECTOR_URL;
        this.traceId = PLACEHOLDER_TRACE_ID;
        this.spanId = PLACEHOLDER_TRACE_ID;
        this.parentSpanId = PLACEHOLDER_TRACE_ID;
    }

    private void configure(RuntimeContext runtimeContext) {
        if (runtimeContext != null && runtimeContext.getConfigurationByKey("OCI_TRACE_COLLECTOR_URL").get() != null && runtimeContext.getConfigurationByKey("OCI_TRACING_ENABLED").get() != null) {
            this.traceCollectorURL = ((String)runtimeContext.getConfigurationByKey("OCI_TRACE_COLLECTOR_URL").get()).isEmpty() ? PLACEHOLDER_TRACE_COLLECTOR_URL : (String)runtimeContext.getConfigurationByKey("OCI_TRACE_COLLECTOR_URL").get();
            try {
                Integer tracingEnabledAsInt = Integer.parseInt((String)runtimeContext.getConfigurationByKey("OCI_TRACING_ENABLED").get());
                this.tracingEnabled = tracingEnabledAsInt != 0;
            }
            catch (NumberFormatException ex) {
                this.tracingEnabled = false;
            }
            this.appName = runtimeContext.getAppName();
            this.fnName = runtimeContext.getFunctionName();
        }
    }

    private void configure(Headers headers) {
        this.flags = headers.get("x-b3-flags").orElse("");
        if (headers.get("x-b3-sampled").isPresent() && Integer.parseInt((String)headers.get("x-b3-sampled").get()) == 0) {
            this.sampled = false;
            return;
        }
        this.sampled = true;
        this.traceId = headers.get("x-b3-traceid").orElse(PLACEHOLDER_TRACE_ID);
        this.spanId = headers.get("x-b3-spanid").orElse(PLACEHOLDER_TRACE_ID);
        this.parentSpanId = headers.get("x-b3-parentspanid").orElse(PLACEHOLDER_TRACE_ID);
    }

    public InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public String getServiceName() {
        return this.appName.toLowerCase() + "::" + this.fnName.toLowerCase();
    }

    public String getTraceCollectorURL() {
        return this.traceCollectorURL;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public String getParentSpanId() {
        return this.parentSpanId;
    }

    public Boolean isSampled() {
        return this.sampled;
    }

    public String getFlags() {
        return this.flags;
    }

    public Boolean isTracingEnabled() {
        return this.tracingEnabled;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getFunctionName() {
        return this.fnName;
    }
}

