/*
 * Copyright 2017 FOLIO Co., Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.folio_sec.reladomo.scala_api.operation

import com.gs.fw.common.mithra.finder._

case class OperationWrapper(underlying: Operation) {

  def and(op: Operation): Operation               = underlying.and(op)
  def and(op: OperationWrapper): OperationWrapper = OperationWrapper(underlying.and(op.underlying))

  def or(op: Operation): Operation               = underlying.or(op)
  def or(op: OperationWrapper): OperationWrapper = OperationWrapper(underlying.or(op.underlying))

}
