/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.transport;

import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.MessageHandler;
import com.sforce.ws.MessageHandlerWithHeaders;
import com.sforce.ws.tools.VersionInfo;
import com.sforce.ws.transport.Transport;
import com.sforce.ws.util.Base64;
import com.sforce.ws.util.FileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class JdkHttpTransport
implements Transport {
    private HttpURLConnection connection;
    private boolean successful;
    private ConnectorConfig config;
    private URL url;

    public JdkHttpTransport() {
    }

    public JdkHttpTransport(ConnectorConfig config) {
        this.setConfig(config);
    }

    @Override
    public void setConfig(ConnectorConfig config) {
        this.config = config;
    }

    public OutputStream connect(String uri, HashMap<String, String> httpHeaders) throws IOException {
        return this.connectLocal(uri, httpHeaders, true);
    }

    public OutputStream connect(String uri, HashMap<String, String> httpHeaders, boolean enableCompression) throws IOException {
        return this.connectLocal(uri, httpHeaders, enableCompression);
    }

    @Override
    public OutputStream connect(String uri, String soapAction) throws IOException {
        if (soapAction == null) {
            soapAction = "";
        }
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("SOAPAction", "\"" + soapAction + "\"");
        header.put("Content-Type", "text/xml; charset=UTF-8");
        header.put("Accept", "text/xml");
        return this.connectLocal(uri, header);
    }

    private OutputStream connectLocal(String uri, HashMap<String, String> httpHeaders) throws IOException {
        return this.connectLocal(uri, httpHeaders, true);
    }

    private OutputStream connectLocal(String uri, HashMap<String, String> httpHeaders, boolean enableCompression) throws IOException {
        return this.wrapOutput(this.connectRaw(uri, httpHeaders, enableCompression), enableCompression);
    }

    private OutputStream wrapOutput(OutputStream output, boolean enableCompression) throws IOException {
        if (this.config.getMaxRequestSize() > 0) {
            output = new LimitingOutputStream(this.config.getMaxRequestSize(), output);
        }
        if (enableCompression && this.config.isCompression()) {
            output = new GZIPOutputStream(output);
        }
        if (this.config.isTraceMessage()) {
            output = new TeeOutputStream(output);
        }
        if (this.config.hasMessageHandlers()) {
            output = new MessageHandlerOutputStream(output);
        }
        return output;
    }

    private OutputStream connectRaw(String uri, HashMap<String, String> httpHeaders, boolean enableCompression) throws IOException {
        this.url = new URL(uri);
        this.connection = JdkHttpTransport.createConnection(this.config, this.url, httpHeaders, enableCompression);
        this.connection.setRequestMethod("POST");
        this.connection.setDoInput(true);
        this.connection.setDoOutput(true);
        if (this.config.useChunkedPost()) {
            this.connection.setChunkedStreamingMode(4096);
        }
        return this.connection.getOutputStream();
    }

    public static HttpURLConnection createConnection(ConnectorConfig config, URL url, HashMap<String, String> httpHeaders) throws IOException {
        return JdkHttpTransport.createConnection(config, url, httpHeaders, true);
    }

    public static HttpURLConnection createConnection(ConnectorConfig config, URL url, HashMap<String, String> httpHeaders, boolean enableCompression) throws IOException {
        if (config.isTraceMessage()) {
            config.getTraceStream().println("WSC: Creating a new connection to " + url + " Proxy = " + config.getProxy() + " username " + config.getProxyUsername());
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection(config.getProxy());
        connection.addRequestProperty("User-Agent", VersionInfo.info());
        if (config.getHeaders() != null) {
            for (Map.Entry<String, String> ent : config.getHeaders().entrySet()) {
                connection.setRequestProperty(ent.getKey(), ent.getValue());
            }
        }
        if (enableCompression && config.isCompression()) {
            connection.addRequestProperty("Content-Encoding", "gzip");
            connection.addRequestProperty("Accept-Encoding", "gzip");
        }
        if (config.getProxyUsername() != null) {
            String token = config.getProxyUsername() + ":" + config.getProxyPassword();
            String auth = "Basic " + new String(Base64.encode(token.getBytes()));
            connection.addRequestProperty("Proxy-Authorization", auth);
            connection.addRequestProperty("Https-Proxy-Authorization", auth);
        }
        if (httpHeaders != null) {
            for (Map.Entry<String, String> entry : httpHeaders.entrySet()) {
                connection.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        if (config.getReadTimeout() != 0) {
            connection.setReadTimeout(config.getReadTimeout());
        }
        if (config.getConnectionTimeout() != 0) {
            connection.setConnectTimeout(config.getConnectionTimeout());
        }
        return connection;
    }

    @Override
    public InputStream getContent() throws IOException {
        InputStream in;
        block10: {
            try {
                this.successful = true;
                in = this.connection.getInputStream();
            }
            catch (IOException e) {
                this.successful = false;
                in = this.connection.getErrorStream();
                if (in != null) break block10;
                throw e;
            }
        }
        String encoding = this.connection.getHeaderField("Content-Encoding");
        if (this.config.getMaxResponseSize() > 0) {
            in = new LimitingInputStream(this.config.getMaxResponseSize(), in);
        }
        if ("gzip".equals(encoding)) {
            in = new GZIPInputStream(in);
        }
        if (this.config.hasMessageHandlers() || this.config.isTraceMessage()) {
            byte[] bytes = FileUtil.toBytes(in);
            in = new ByteArrayInputStream(bytes);
            if (this.config.hasMessageHandlers()) {
                Iterator<MessageHandler> it = this.config.getMessagerHandlers();
                while (it.hasNext()) {
                    MessageHandler handler = it.next();
                    if (handler instanceof MessageHandlerWithHeaders) {
                        ((MessageHandlerWithHeaders)handler).handleResponse(this.url, bytes, this.connection.getHeaderFields());
                        continue;
                    }
                    handler.handleResponse(this.url, bytes);
                }
            }
            if (this.config.isTraceMessage()) {
                Map<String, List<String>> headers = this.connection.getHeaderFields();
                for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                    this.config.getTraceStream().print((Object)header.getKey());
                    this.config.getTraceStream().print("=");
                    this.config.getTraceStream().println(header.getValue());
                }
                new TeeInputStream(this.config, bytes);
            }
        }
        return in;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    public class TeeOutputStream
    extends OutputStream {
        private OutputStream out;

        public TeeOutputStream(OutputStream out) {
            JdkHttpTransport.this.config.getTraceStream().println("------------ Request start   ----------");
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            JdkHttpTransport.this.config.getTraceStream().write((char)b);
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            JdkHttpTransport.this.config.getTraceStream().write(b);
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            JdkHttpTransport.this.config.getTraceStream().write(b, off, len);
            this.out.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            JdkHttpTransport.this.config.getTraceStream().println();
            JdkHttpTransport.this.config.getTraceStream().flush();
            this.out.close();
            JdkHttpTransport.this.config.getTraceStream().println("------------ Request end   ----------");
        }
    }

    public static class LimitingOutputStream
    extends OutputStream {
        private int size = 0;
        private int maxSize;
        private OutputStream out;

        public LimitingOutputStream(int maxSize, OutputStream out) {
            this.maxSize = maxSize;
            this.out = out;
        }

        public int getSize() {
            return this.size;
        }

        @Override
        public void write(int b) throws IOException {
            ++this.size;
            this.checkSizeLimit();
            this.out.write(b);
        }

        private void checkSizeLimit() throws IOException {
            if (this.size > this.maxSize) {
                throw new IOException("Exceeded max size limit of " + this.maxSize + " with request size " + this.size);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.size += b.length;
            this.checkSizeLimit();
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.size += len;
            this.checkSizeLimit();
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }

    public static class LimitingInputStream
    extends InputStream {
        private int maxSize;
        private int size;
        private InputStream in;

        public LimitingInputStream(int maxSize, InputStream in) {
            this.in = in;
            this.maxSize = maxSize;
        }

        private void checkSizeLimit() throws IOException {
            if (this.size > this.maxSize) {
                throw new IOException("Exceeded max size limit of " + this.maxSize + " with response size " + this.size);
            }
        }

        @Override
        public int read() throws IOException {
            int result = this.in.read();
            ++this.size;
            this.checkSizeLimit();
            return result;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int len = this.in.read(b);
            this.size += len;
            this.checkSizeLimit();
            return len;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int length = this.in.read(b, off, len);
            this.size += length;
            this.checkSizeLimit();
            return length;
        }

        @Override
        public long skip(long n) throws IOException {
            long len = this.in.skip(n);
            this.size = (int)((long)this.size + len);
            this.checkSizeLimit();
            return len;
        }

        @Override
        public int available() throws IOException {
            return this.in.available();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.in.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.in.reset();
        }

        @Override
        public boolean markSupported() {
            return this.in.markSupported();
        }
    }

    public class MessageHandlerOutputStream
    extends OutputStream {
        private ByteArrayOutputStream bout = new ByteArrayOutputStream();
        private OutputStream output;

        public MessageHandlerOutputStream(OutputStream output) {
            this.output = output;
        }

        @Override
        public void write(int b) throws IOException {
            this.bout.write((char)b);
            this.output.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.bout.write(b);
            this.output.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.bout.write(b, off, len);
            this.output.write(b, off, len);
        }

        @Override
        public void close() throws IOException {
            this.bout.close();
            this.output.close();
            Iterator<MessageHandler> it = JdkHttpTransport.this.config.getMessagerHandlers();
            while (it.hasNext()) {
                MessageHandler handler = it.next();
                handler.handleRequest(JdkHttpTransport.this.url, this.bout.toByteArray());
            }
        }
    }

    public static class TeeInputStream {
        private int level = 0;
        private ConnectorConfig config;

        public TeeInputStream(ConnectorConfig config, byte[] bytes) {
            this.config = config;
            config.getTraceStream().println("------------ Response start ----------");
            if (config.isPrettyPrintXml()) {
                this.prettyPrint(bytes);
            } else {
                config.getTraceStream().print(new String(bytes));
            }
            config.getTraceStream().println();
            config.getTraceStream().println("------------ Response end   ----------");
        }

        private void prettyPrint(byte[] bytes) {
            boolean newLine = true;
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == 60) {
                    if (i + 1 < bytes.length) {
                        this.level = bytes[i + 1] == 47 ? --this.level : ++this.level;
                    }
                    for (int j = 0; newLine && j < this.level; ++j) {
                        this.config.getTraceStream().print("  ");
                    }
                }
                this.config.getTraceStream().write(bytes[i]);
                if (bytes[i] != 62) continue;
                if (i + 1 < bytes.length && bytes[i + 1] == 60) {
                    this.config.getTraceStream().println();
                    newLine = true;
                    continue;
                }
                newLine = false;
            }
        }
    }
}

