/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.tools;

import com.sforce.ws.bind.NameMapper;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.template.Template;
import com.sforce.ws.template.TemplateException;
import com.sforce.ws.tools.ComplexTypeGenerator;
import com.sforce.ws.tools.ConnectionGenerator;
import com.sforce.ws.tools.SimpleTypeGenerator;
import com.sforce.ws.tools.ToolsException;
import com.sforce.ws.util.FileUtil;
import com.sforce.ws.util.Verbose;
import com.sforce.ws.wsdl.ComplexType;
import com.sforce.ws.wsdl.Definitions;
import com.sforce.ws.wsdl.Schema;
import com.sforce.ws.wsdl.SfdcApiType;
import com.sforce.ws.wsdl.SimpleType;
import com.sforce.ws.wsdl.Types;
import com.sforce.ws.wsdl.WsdlFactory;
import com.sforce.ws.wsdl.WsdlParseException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class wsdlc {
    private File tempDir;
    private TypeMapper typeMapper = new TypeMapper();
    private ArrayList<String> javaFiles = new ArrayList();
    private String packagePrefix = null;
    private boolean laxMinOccursMode;
    private static final String LAX_MINOCCURS = "lax-minoccurs-checking";
    private static final String PACKAGE_PREFIX = "package-prefix";
    private static final String SOBJECT_TEMPLATE = "com/sforce/ws/tools/sobject.template";
    private static final String AGG_RESULT_TEMPLATE = "com/sforce/ws/tools/aggregateResult.template";

    public wsdlc(String wsdlFile, String jarFile, String temp) throws ToolsException, WsdlParseException, IOException, TemplateException {
        long start = System.currentTimeMillis();
        this.checkTargetFile(jarFile);
        this.createTempDir(temp);
        Verbose.log("Created temp dir: " + this.tempDir.getAbsolutePath());
        this.packagePrefix = System.getProperty(PACKAGE_PREFIX);
        this.laxMinOccursMode = System.getProperty(LAX_MINOCCURS) != null;
        this.typeMapper.setPackagePrefix(this.packagePrefix);
        Definitions definitions = WsdlFactory.create(wsdlFile);
        SfdcApiType type = definitions.getApiType();
        Types types = definitions.getTypes();
        this.generateTypes(types);
        this.generateConnection(definitions);
        this.generateConnector(definitions);
        if (type != null && type.getSobjectNamespace() != null) {
            this.generateSObject(definitions);
            this.generateAggregateResult(definitions);
        }
        this.compileTypes();
        this.generateJarFile(jarFile);
        if (Boolean.parseBoolean(System.getProperty("del-temp-dir", "true"))) {
            Verbose.log("Delete temp dir: " + this.tempDir.getAbsolutePath());
            Verbose.log("Set system property del-temp-dir=false to not delete temp dir.");
            FileUtil.deleteDir(this.tempDir);
        }
        Verbose.log("Completed " + wsdlFile + " in (ms) " + (System.currentTimeMillis() - start));
    }

    private void createTempDir(String temp) throws IOException {
        if (temp == null) {
            this.tempDir = File.createTempFile("wsdlc-temp-", "-dir", null);
            this.tempDir.delete();
            this.tempDir.mkdir();
        } else {
            this.tempDir = new File(temp);
        }
    }

    private void checkTargetFile(String jarFile) throws ToolsException {
        if (!jarFile.endsWith(".jar")) {
            throw new ToolsException("<jar-file> must have a .jar extension");
        }
        File jf = new File(jarFile);
        if (jf.exists()) {
            throw new ToolsException("<jar-file> already exists");
        }
        File parentDir = jf.getParentFile();
        if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
            throw new ToolsException("<jar-file> path does not exist");
        }
    }

    private void generateConnector(Definitions definitions) throws IOException, TemplateException {
        ConnectionGenerator connectionGenerator = new ConnectionGenerator(definitions, this.tempDir, this.typeMapper, this.packagePrefix);
        String file = connectionGenerator.generateConnector();
        this.javaFiles.add(file);
    }

    private void generateConnection(Definitions definitions) throws IOException, TemplateException {
        ConnectionGenerator connectionGenerator = new ConnectionGenerator(definitions, this.tempDir, this.typeMapper, this.packagePrefix);
        String file = connectionGenerator.generateConnection();
        this.javaFiles.add(file);
    }

    private void generateAggregateResult(Definitions definitions) throws IOException, TemplateException {
        if (definitions.getApiType() == SfdcApiType.Enterprise) {
            String packageName = NameMapper.getPackageName(definitions.getApiType().getSobjectNamespace(), this.packagePrefix);
            File dir = FileUtil.mkdirs(packageName, this.tempDir);
            Template template = new Template();
            template.setProperty("packageName", packageName);
            String className = "AggregateResult";
            File javaFile = new File(dir, className + ".java");
            template.exec(AGG_RESULT_TEMPLATE, javaFile.getAbsolutePath());
            this.javaFiles.add(javaFile.getAbsolutePath());
        }
    }

    private void generateSObject(Definitions definitions) throws IOException, TemplateException {
        if (definitions.getApiType() == SfdcApiType.Partner || definitions.getApiType() == SfdcApiType.CrossInstance || definitions.getApiType() == SfdcApiType.Internal || definitions.getApiType() == SfdcApiType.ClientSync || definitions.getApiType() == SfdcApiType.SyncApi) {
            String packageName = NameMapper.getPackageName(definitions.getApiType().getSobjectNamespace(), this.packagePrefix);
            File dir = FileUtil.mkdirs(packageName, this.tempDir);
            Template template = new Template();
            template.setProperty("packageName", packageName);
            String className = "SObject";
            File javaFile = new File(dir, className + ".java");
            template.exec(SOBJECT_TEMPLATE, javaFile.getAbsolutePath());
            this.javaFiles.add(javaFile.getAbsolutePath());
        }
    }

    private void generateJarFile(String jarFile) throws IOException {
        Verbose.log("Generating jar file ... " + jarFile);
        FileOutputStream out = new FileOutputStream(jarFile);
        InputStream manifestIo = this.getManifest();
        Manifest manifest = new Manifest(manifestIo);
        JarOutputStream jar = new JarOutputStream((OutputStream)out, manifest);
        int rootLen = this.tempDir.getAbsolutePath().length();
        int len = "java".length();
        for (String javaFile : this.javaFiles) {
            String classFile = javaFile.substring(0, javaFile.length() - len) + "class";
            String className = classFile.substring(rootLen + 1);
            this.addFileToJar(className, classFile, jar);
            String javaName = javaFile.substring(rootLen + 1);
            this.addFileToJar(javaName, javaFile, jar);
        }
        if (Boolean.parseBoolean(System.getProperty("standalone-jar", "false"))) {
            Verbose.log("Adding runtime classes to the jar");
            this.addRuntimeClasses(jar);
        } else {
            Verbose.log("To include runtime classes in the generated jar please set system property standalone-jar=true");
        }
        jar.close();
        out.close();
        Verbose.log("Generated jar file " + jarFile);
    }

    private void addFileToJar(String className, String classFile, JarOutputStream jar) throws IOException {
        int cb;
        className = className.replace('\\', '/');
        FileInputStream fio = new FileInputStream(classFile);
        jar.putNextEntry(new JarEntry(className));
        byte[] buffer = new byte[8192];
        while ((cb = fio.read(buffer)) != -1) {
            jar.write(buffer, 0, cb);
        }
        jar.closeEntry();
        fio.close();
    }

    private void addRuntimeClasses(JarOutputStream jar) throws IOException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        ArrayList<String> runtimeClasses = this.getRuntimeClasses(cl);
        for (String c : runtimeClasses) {
            int ch;
            jar.putNextEntry(new JarEntry(c));
            InputStream in = cl.getResourceAsStream(c);
            while ((ch = in.read()) != -1) {
                jar.write((char)ch);
            }
            jar.closeEntry();
            in.close();
        }
    }

    private ArrayList<String> getRuntimeClasses(ClassLoader cl) throws IOException {
        String line;
        ArrayList<String> classes = new ArrayList<String>();
        InputStream in = cl.getResourceAsStream("com/sforce/ws/runtime-classes.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((line = reader.readLine()) != null) {
            classes.add(line);
        }
        reader.close();
        return classes;
    }

    private InputStream getManifest() {
        String m = "Manifest-Version: 1.0\nCreated-By: 1.4.2_05-b04 (Sun Microsystems Inc.)\n";
        return new ByteArrayInputStream(m.getBytes());
    }

    private void compileTypes() throws ToolsException {
        Compiler compiler = new Compiler();
        compiler.compile(this.javaFiles.toArray(new String[this.javaFiles.size()]));
    }

    private void generateTypes(Types types) throws IOException, TemplateException {
        Verbose.log("Generating Java files from schema ...");
        Iterator<Schema> schemas = types.getSchemas();
        while (schemas.hasNext()) {
            this.generate(types, schemas.next());
        }
        Verbose.log("Generated " + this.javaFiles.size() + " java files.");
    }

    private void generate(Types types, Schema schema) throws IOException, TemplateException {
        Iterator<ComplexType> complexTypes = schema.getComplexTypes();
        while (complexTypes.hasNext()) {
            ComplexType complexType = complexTypes.next();
            if (this.typeMapper.isWellKnownType(complexType.getSchema().getTargetNamespace(), complexType.getName())) continue;
            ComplexTypeGenerator typeGenerator = new ComplexTypeGenerator(types, schema, complexType, this.tempDir, this.typeMapper, this.laxMinOccursMode);
            String file = typeGenerator.generate();
            this.javaFiles.add(file);
        }
        Iterator<SimpleType> simpleTypes = schema.getSimpleTypes();
        while (simpleTypes.hasNext()) {
            SimpleType simpleType = simpleTypes.next();
            if (this.typeMapper.isWellKnownType(simpleType.getSchema().getTargetNamespace(), simpleType.getName())) continue;
            SimpleTypeGenerator typeGenerator = new SimpleTypeGenerator(types, schema, simpleType, this.tempDir, this.typeMapper);
            String file = typeGenerator.generate();
            this.javaFiles.add(file);
        }
    }

    public static void main(String[] args) throws WsdlParseException, IOException, TemplateException {
        try {
            wsdlc.run(args);
        }
        catch (ToolsException e) {
            System.out.println(e);
            System.exit(1);
        }
    }

    static void run(String[] args) throws ToolsException, WsdlParseException, IOException, TemplateException {
        if (args.length == 2) {
            new wsdlc(args[0], args[1], null);
        } else if (args.length == 3) {
            new wsdlc(args[0], args[1], args[2]);
        } else {
            throw new ToolsException(" usage: java com.sforce.ws.tools.wsdlc <wsdl-file> <jar-file> [temp-dir]");
        }
    }

    public static class ToolsJarClassLoader
    extends ClassLoader {
        private JarFile toolsJar;

        ToolsJarClassLoader(ClassLoader parent) throws IOException {
            super(parent);
            String javaHome = System.getProperty("java.home");
            if (javaHome.endsWith("jre")) {
                javaHome = javaHome.substring(0, javaHome.length() - 3);
            }
            if (!javaHome.endsWith("/")) {
                javaHome = javaHome + "/";
            }
            String tj = javaHome + "lib/tools.jar";
            File tjf = new File(tj);
            this.toolsJar = new JarFile(tjf);
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            byte[] b;
            try {
                b = this.getBytes(name);
            }
            catch (IOException e) {
                throw new ClassNotFoundException(name);
            }
            return this.defineClass(null, b, 0, b.length);
        }

        private byte[] getBytes(String name) throws IOException, ClassNotFoundException {
            int ch;
            name = name.replace(".", "/");
            JarEntry entry = this.toolsJar.getJarEntry(name = name + ".class");
            if (entry == null) {
                throw new ClassNotFoundException(name);
            }
            InputStream io = this.toolsJar.getInputStream(entry);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            while ((ch = io.read()) != -1) {
                bout.write((char)ch);
            }
            io.close();
            return bout.toByteArray();
        }
    }

    class Compiler {
        private Object main;
        private Method method;

        public Compiler() throws ToolsException {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            try {
                this.findCompiler(loader);
            }
            catch (ClassNotFoundException e) {
                this.findCompilerInToolsJar(loader);
            }
            catch (NoSuchMethodException e) {
                this.throwToolsexception(e);
            }
            catch (IllegalAccessException e) {
                this.throwToolsexception(e);
            }
            catch (InstantiationException e) {
                this.throwToolsexception(e);
            }
        }

        private void findCompilerInToolsJar(ClassLoader loader) throws ToolsException {
            try {
                ToolsJarClassLoader tloader = new ToolsJarClassLoader(loader);
                this.findCompiler(tloader);
            }
            catch (MalformedURLException e) {
                this.throwToolsexception(e);
            }
            catch (NoSuchMethodException e) {
                this.throwToolsexception(e);
            }
            catch (IllegalAccessException e) {
                this.throwToolsexception(e);
            }
            catch (InstantiationException e) {
                this.throwToolsexception(e);
            }
            catch (ClassNotFoundException e) {
                this.throwToolsexception(e);
            }
            catch (IOException e) {
                this.throwToolsexception(e);
            }
        }

        private void findCompiler(ClassLoader loader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException {
            Class<?> c = loader.loadClass("com.sun.tools.javac.Main");
            Class<?> arg = new String[0].getClass();
            this.main = c.newInstance();
            this.method = c.getMethod("compile", arg);
        }

        private void throwToolsexception(Exception e) throws ToolsException {
            e.printStackTrace();
            throw new ToolsException("Unable to find compiler. Make sure that tools.jar is in your classpath: " + e);
        }

        public void compile(String[] files) throws ToolsException {
            String target = System.getProperty("compileTarget");
            if (target == null) {
                target = "1.6";
            }
            Verbose.log("Compiling to target " + target + "... ");
            String[] args = new String[]{"-g", "-d", wsdlc.this.tempDir.getAbsolutePath(), "-sourcepath", wsdlc.this.tempDir.getAbsolutePath(), "-target", target};
            String[] call = new String[args.length + files.length];
            System.arraycopy(args, 0, call, 0, args.length);
            System.arraycopy(files, 0, call, args.length, files.length);
            try {
                Integer result = (Integer)this.method.invoke(this.main, new Object[]{call});
                if (result != 0) {
                    throw new ToolsException("Failed to compile");
                }
            }
            catch (IllegalAccessException e) {
                throw new ToolsException("Failed to compile: " + e);
            }
            catch (InvocationTargetException e) {
                throw new ToolsException("Failed to compile: " + e);
            }
            Verbose.log("Compiled " + files.length + " java files.");
        }
    }
}

