/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.async;

import com.sforce.async.AsyncApiException;
import com.sforce.async.AsyncExceptionCode;
import com.sforce.async.AsyncXmlOutputStream;
import com.sforce.async.BatchInfo;
import com.sforce.async.BulkConnection;
import com.sforce.async.SObject;
import com.sforce.ws.ConnectionException;
import com.sforce.ws.parser.PullParserException;
import com.sforce.ws.parser.XmlInputStream;
import com.sforce.ws.parser.XmlOutputStream;
import com.sforce.ws.transport.Transport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BatchRequest {
    private XmlOutputStream xmlStream;
    private Transport transport;

    public BatchRequest(Transport transport, OutputStream out) throws IOException {
        this.transport = transport;
        this.xmlStream = new AsyncXmlOutputStream(out, false);
        this.xmlStream.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        this.xmlStream.writeStartTag("http://www.force.com/2009/06/asyncapi/dataload", "sObjects");
    }

    public void addSObject(SObject object) throws AsyncApiException {
        try {
            object.write(this.xmlStream);
        }
        catch (IOException e) {
            throw new AsyncApiException("Failed to add SObject", AsyncExceptionCode.ClientInputError, e);
        }
    }

    public void addSObjects(SObject[] objects) throws AsyncApiException {
        SObject[] sObjectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            SObject object = sObjectArray[n2];
            this.addSObject(object);
            ++n2;
        }
    }

    public BatchInfo completeRequest() throws AsyncApiException {
        try {
            this.xmlStream.writeEndTag("http://www.force.com/2009/06/asyncapi/dataload", "sObjects");
            this.xmlStream.endDocument();
            this.xmlStream.close();
            InputStream in = this.transport.getContent();
            if (this.transport.isSuccessful()) {
                return BatchRequest.loadBatchInfo(in);
            }
            BulkConnection.parseAndThrowException(in);
        }
        catch (IOException e) {
            throw new AsyncApiException("Failed to complete request", AsyncExceptionCode.ClientInputError, e);
        }
        catch (PullParserException e) {
            throw new AsyncApiException("Failed to complete request", AsyncExceptionCode.ClientInputError, e);
        }
        catch (ConnectionException e) {
            throw new AsyncApiException("Failed to complete request", AsyncExceptionCode.ClientInputError, e);
        }
        return null;
    }

    static BatchInfo loadBatchInfo(InputStream in) throws PullParserException, IOException, ConnectionException {
        BatchInfo info = new BatchInfo();
        XmlInputStream xin = new XmlInputStream();
        xin.setInput(in, "UTF-8");
        info.load(xin, BulkConnection.typeMapper);
        return info;
    }
}

