/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.transport;

import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.sforce.ws.ConnectorConfig;
import com.sforce.ws.tools.VersionInfo;
import com.sforce.ws.transport.LimitingInputStream;
import com.sforce.ws.transport.LimitingOutputStream;
import com.sforce.ws.transport.Transport;
import com.sforce.ws.util.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GaeHttpTransport
implements Transport {
    private static Logger log = Logger.getLogger("soapconnection send");
    private URLFetchService connection = URLFetchServiceFactory.getURLFetchService();
    private HTTPRequest request;
    private boolean successful;
    private ConnectorConfig config;
    private URL url;
    private ByteArrayOutputStream output;

    @Override
    public void setConfig(ConnectorConfig config) {
        this.config = config;
    }

    @Override
    public OutputStream connect(String uri, String soapAction) throws IOException {
        if (soapAction == null) {
            soapAction = "";
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "text/xml; charset=UTF-8");
        headers.put("Accept", "text/xml");
        headers.put("User-Agent", VersionInfo.info());
        headers.put("SOAPAction", "\"" + soapAction + "\"");
        return this.connect(uri, headers, true);
    }

    @Override
    public OutputStream connect(String endpoint, HashMap<String, String> headers) throws IOException {
        return this.connect(endpoint, headers, true);
    }

    @Override
    public OutputStream connect(String uri, HashMap<String, String> httpHeaders, boolean enableCompression) throws IOException {
        return this.wrapOutput(this.connectRaw(uri, httpHeaders, enableCompression), enableCompression);
    }

    private OutputStream wrapOutput(OutputStream output, boolean enableCompression) throws IOException {
        if (this.config.getMaxRequestSize() > 0) {
            output = new LimitingOutputStream(this.config.getMaxRequestSize(), output);
        }
        if (enableCompression && this.config.isCompression()) {
            output = new GZIPOutputStream(output);
        }
        return output;
    }

    private OutputStream connectRaw(String uri, Map<String, String> httpHeaders, boolean enableCompression) throws IOException {
        log.info(uri);
        this.url = new URL(uri);
        this.request = GaeHttpTransport.createRequest(this.config, this.url, httpHeaders, enableCompression);
        this.output = new ByteArrayOutputStream();
        return this.output;
    }

    public static HTTPRequest createRequest(ConnectorConfig config, URL url, Map<String, String> httpHeaders) throws IOException {
        return GaeHttpTransport.createRequest(config, url, httpHeaders, true);
    }

    public static HTTPRequest createRequest(ConnectorConfig config, URL url, Map<String, String> httpHeaders, boolean enableCompression) throws IOException {
        if (config.isTraceMessage()) {
            config.getTraceStream().println("WSC: Creating a new connection to " + url + " Proxy = " + config.getProxy() + " username " + config.getProxyUsername());
        }
        FetchOptions fetchOptions = FetchOptions.Builder.withDeadline((double)(config.getReadTimeout() / 1000)).validateCertificate();
        HTTPRequest request = new HTTPRequest(url, HTTPMethod.POST, fetchOptions);
        if (httpHeaders == null || httpHeaders.get("User-Agent") == null && httpHeaders.get("user-agent") == null) {
            request.addHeader(new HTTPHeader("User-Agent", VersionInfo.info()));
        }
        if (config.getHeaders() != null) {
            for (Map.Entry<String, String> ent : config.getHeaders().entrySet()) {
                request.addHeader(new HTTPHeader(ent.getKey(), ent.getValue()));
            }
        }
        if (enableCompression && config.isCompression()) {
            request.addHeader(new HTTPHeader("Content-Encoding", "gzip"));
            request.addHeader(new HTTPHeader("Accept-Encoding", "gzip"));
        }
        if (config.getProxyUsername() != null) {
            String token = String.valueOf(config.getProxyUsername()) + ":" + config.getProxyPassword();
            String auth = "Basic " + new String(Base64.encode(token.getBytes()));
            request.addHeader(new HTTPHeader("Proxy-Authorization", auth));
            request.addHeader(new HTTPHeader("Https-Proxy-Authorization", auth));
        }
        if (httpHeaders != null) {
            for (Map.Entry<String, String> entry : httpHeaders.entrySet()) {
                request.addHeader(new HTTPHeader(entry.getKey(), entry.getValue()));
            }
        }
        return request;
    }

    List<String> getHeaders(HTTPResponse resp, String headerName) {
        ArrayList<String> b = new ArrayList<String>();
        for (HTTPHeader h : resp.getHeadersUncombined()) {
            if (!headerName.equalsIgnoreCase(h.getName())) continue;
            b.add(h.getValue());
        }
        return b;
    }

    String getHeader(HTTPResponse resp, String headerName) {
        for (HTTPHeader h : resp.getHeadersUncombined()) {
            if (!headerName.equalsIgnoreCase(h.getName())) continue;
            return h.getValue();
        }
        return null;
    }

    @Override
    public InputStream getContent() throws IOException {
        InputStream in;
        try {
            this.successful = true;
            if (this.config.isTraceMessage()) {
                log.info(this.output.toString());
            }
            this.request.setPayload(this.output.toByteArray());
            HTTPResponse resp = this.connection.fetch(this.request);
            byte[] bytes = resp.getContent();
            String contentid = "Content-ID: <root.message@cxf.apache.org>";
            String str = new String(bytes);
            if (str.contains("Content-ID: <root.message@cxf.apache.org>")) {
                str = str.split("Content-ID: <root.message@cxf.apache.org>")[1].trim();
            }
            bytes = str.getBytes();
            if (this.config.isTraceMessage()) {
                log.info(new String(bytes));
            }
            in = new ByteArrayInputStream(bytes);
            this.successful = resp.getResponseCode() < 400;
            String encoding = this.getHeader(resp, "Content-Encoding");
            if (this.config.getMaxResponseSize() > 0) {
                in = new LimitingInputStream(this.config.getMaxResponseSize(), in);
            }
            if ("gzip".equals(encoding)) {
                in = new GZIPInputStream(in);
            }
            if (this.config.isTraceMessage()) {
                log.info(new String(bytes));
            }
        }
        catch (IOException e) {
            this.successful = false;
            in = new ByteArrayInputStream(e.getMessage().getBytes());
            log.warning("getContent: " + e.getMessage());
        }
        return in;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }
}

