/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.shade.org.antlr.stringtemplate;

import com.sforce.ws.shade.org.antlr.stringtemplate.AttributeRenderer;
import com.sforce.ws.shade.org.antlr.stringtemplate.AutoIndentWriter;
import com.sforce.ws.shade.org.antlr.stringtemplate.StringTemplate;
import com.sforce.ws.shade.org.antlr.stringtemplate.StringTemplateErrorListener;
import com.sforce.ws.shade.org.antlr.stringtemplate.StringTemplateGroupInterface;
import com.sforce.ws.shade.org.antlr.stringtemplate.StringTemplateGroupLoader;
import com.sforce.ws.shade.org.antlr.stringtemplate.StringTemplateWriter;
import com.sforce.ws.shade.org.antlr.stringtemplate.language.AngleBracketTemplateLexer;
import com.sforce.ws.shade.org.antlr.stringtemplate.language.DefaultTemplateLexer;
import com.sforce.ws.shade.org.antlr.stringtemplate.language.GroupLexer;
import com.sforce.ws.shade.org.antlr.stringtemplate.language.GroupParser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StringTemplateGroup {
    protected String name;
    protected Map templates = new HashMap();
    protected Map maps = new HashMap();
    protected Class templateLexerClass = null;
    protected static Class defaultTemplateLexerClass = DefaultTemplateLexer.class;
    protected String rootDir = null;
    protected static Map nameToGroupMap = Collections.synchronizedMap(new HashMap());
    protected static Map nameToInterfaceMap = Collections.synchronizedMap(new HashMap());
    protected StringTemplateGroup superGroup = null;
    protected List interfaces = null;
    protected boolean templatesDefinedInGroupFile = false;
    protected Class userSpecifiedWriter;
    protected boolean debugTemplateOutput = false;
    protected Set noDebugStartStopStrings;
    protected Map attributeRenderers;
    private static StringTemplateGroupLoader groupLoader = null;
    protected StringTemplateErrorListener listener = DEFAULT_ERROR_LISTENER;
    public static StringTemplateErrorListener DEFAULT_ERROR_LISTENER = new StringTemplateErrorListener(){

        public void error(String s, Throwable e) {
            System.err.println(s);
            if (e != null) {
                e.printStackTrace(System.err);
            }
        }

        public void warning(String s) {
            System.out.println(s);
        }
    };
    protected static final StringTemplate NOT_FOUND_ST = new StringTemplate();
    protected int refreshIntervalInSeconds = 2147483;
    protected long lastCheckedDisk = 0L;
    String fileCharEncoding = System.getProperty("file.encoding");

    public StringTemplateGroup(String name, String rootDir) {
        this(name, rootDir, DefaultTemplateLexer.class);
    }

    public StringTemplateGroup(String name, String rootDir, Class lexer) {
        this.name = name;
        this.rootDir = rootDir;
        this.lastCheckedDisk = System.currentTimeMillis();
        nameToGroupMap.put(name, this);
        this.templateLexerClass = lexer;
    }

    public StringTemplateGroup(String name) {
        this(name, null, null);
    }

    public StringTemplateGroup(String name, Class lexer) {
        this(name, null, lexer);
    }

    public StringTemplateGroup(Reader r) {
        this(r, AngleBracketTemplateLexer.class, DEFAULT_ERROR_LISTENER, null);
    }

    public StringTemplateGroup(Reader r, StringTemplateErrorListener errors) {
        this(r, AngleBracketTemplateLexer.class, errors, null);
    }

    public StringTemplateGroup(Reader r, Class lexer) {
        this(r, lexer, null, null);
    }

    public StringTemplateGroup(Reader r, Class lexer, StringTemplateErrorListener errors) {
        this(r, lexer, errors, null);
    }

    public StringTemplateGroup(Reader r, Class lexer, StringTemplateErrorListener errors, StringTemplateGroup superGroup) {
        this.templatesDefinedInGroupFile = true;
        if (lexer == null) {
            lexer = AngleBracketTemplateLexer.class;
        }
        this.templateLexerClass = lexer;
        if (errors != null) {
            this.listener = errors;
        }
        this.setSuperGroup(superGroup);
        this.parseGroup(r);
        nameToGroupMap.put(this.name, this);
        this.verifyInterfaceImplementations();
    }

    public Class getTemplateLexerClass() {
        if (this.templateLexerClass != null) {
            return this.templateLexerClass;
        }
        return defaultTemplateLexerClass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSuperGroup(StringTemplateGroup superGroup) {
        this.superGroup = superGroup;
    }

    public void setSuperGroup(String superGroupName) {
        StringTemplateGroup superGroup = (StringTemplateGroup)nameToGroupMap.get(superGroupName);
        if (superGroup != null) {
            this.setSuperGroup(superGroup);
            return;
        }
        superGroup = StringTemplateGroup.loadGroup(superGroupName, this.templateLexerClass, null);
        if (superGroup != null) {
            nameToGroupMap.put(superGroupName, superGroup);
            this.setSuperGroup(superGroup);
        } else if (groupLoader == null) {
            this.listener.error("no group loader registered", null);
        }
    }

    public void implementInterface(StringTemplateGroupInterface I) {
        if (this.interfaces == null) {
            this.interfaces = new ArrayList();
        }
        this.interfaces.add(I);
    }

    public void implementInterface(String interfaceName) {
        StringTemplateGroupInterface I = (StringTemplateGroupInterface)nameToInterfaceMap.get(interfaceName);
        if (I != null) {
            this.implementInterface(I);
            return;
        }
        I = StringTemplateGroup.loadInterface(interfaceName);
        if (I != null) {
            nameToInterfaceMap.put(interfaceName, I);
            this.implementInterface(I);
        } else if (groupLoader == null) {
            this.listener.error("no group loader registered", null);
        }
    }

    public StringTemplateGroup getSuperGroup() {
        return this.superGroup;
    }

    public String getGroupHierarchyStackString() {
        LinkedList<String> groupNames = new LinkedList<String>();
        StringTemplateGroup p = this;
        while (p != null) {
            groupNames.add(0, p.name);
            p = p.superGroup;
        }
        return ((Object)groupNames).toString().replaceAll(",", "");
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String rootDir) {
        this.rootDir = rootDir;
    }

    public StringTemplate createStringTemplate() {
        StringTemplate st = new StringTemplate();
        return st;
    }

    protected StringTemplate getInstanceOf(StringTemplate enclosingInstance, String name) throws IllegalArgumentException {
        StringTemplate st = this.lookupTemplate(enclosingInstance, name);
        if (st != null) {
            StringTemplate instanceST = st.getInstanceOf();
            return instanceST;
        }
        return null;
    }

    public StringTemplate getInstanceOf(String name) {
        return this.getInstanceOf(null, name);
    }

    public StringTemplate getInstanceOf(String name, Map attributes) {
        StringTemplate st = this.getInstanceOf(name);
        st.attributes = attributes;
        return st;
    }

    public StringTemplate getEmbeddedInstanceOf(StringTemplate enclosingInstance, String name) throws IllegalArgumentException {
        StringTemplate st = null;
        st = name.startsWith("super.") ? enclosingInstance.getNativeGroup().getInstanceOf(enclosingInstance, name) : this.getInstanceOf(enclosingInstance, name);
        st.setGroup(this);
        st.setEnclosingInstance(enclosingInstance);
        return st;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized StringTemplate lookupTemplate(StringTemplate enclosingInstance, String name) throws IllegalArgumentException {
        if (name.startsWith("super.")) {
            if (this.superGroup == null) throw new IllegalArgumentException(this.getName() + " has no super group; invalid template: " + name);
            int dot = name.indexOf(46);
            name = name.substring(dot + 1, name.length());
            return this.superGroup.lookupTemplate(enclosingInstance, name);
        }
        this.checkRefreshInterval();
        StringTemplate st = (StringTemplate)this.templates.get(name);
        if (st == null) {
            if (!this.templatesDefinedInGroupFile) {
                st = this.loadTemplateFromBeneathRootDirOrCLASSPATH(this.getFileNameFromTemplateName(name));
            }
            if (st == null && this.superGroup != null && (st = this.superGroup.getInstanceOf(name)) != null) {
                st.setGroup(this);
            }
            if (st == null) {
                this.templates.put(name, NOT_FOUND_ST);
                String context = "";
                if (enclosingInstance != null) {
                    context = "; context is " + enclosingInstance.getEnclosingInstanceStackString();
                }
                String hier = this.getGroupHierarchyStackString();
                context = context + "; group hierarchy is " + hier;
                throw new IllegalArgumentException("Can't find template " + this.getFileNameFromTemplateName(name) + context);
            }
        } else {
            if (st != NOT_FOUND_ST) return st;
            return null;
        }
        this.templates.put(name, st);
        return st;
    }

    public StringTemplate lookupTemplate(String name) {
        return this.lookupTemplate(null, name);
    }

    protected void checkRefreshInterval() {
        boolean timeToFlush;
        if (this.templatesDefinedInGroupFile) {
            return;
        }
        boolean bl = timeToFlush = this.refreshIntervalInSeconds == 0 || System.currentTimeMillis() - this.lastCheckedDisk >= (long)(this.refreshIntervalInSeconds * 1000);
        if (timeToFlush) {
            this.templates.clear();
            this.lastCheckedDisk = System.currentTimeMillis();
        }
    }

    protected StringTemplate loadTemplate(String name, BufferedReader r) throws IOException {
        String line;
        String nl = System.getProperty("line.separator");
        StringBuffer buf = new StringBuffer(300);
        while ((line = r.readLine()) != null) {
            buf.append(line);
            buf.append(nl);
        }
        String pattern = buf.toString().trim();
        if (pattern.length() == 0) {
            this.error("no text in template '" + name + "'");
            return null;
        }
        return this.defineTemplate(name, pattern);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StringTemplate loadTemplateFromBeneathRootDirOrCLASSPATH(String fileName) {
        StringTemplate template = null;
        String name = this.getTemplateNameFromFileName(fileName);
        if (this.rootDir == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream is = cl.getResourceAsStream(fileName);
            if (is == null) {
                cl = this.getClass().getClassLoader();
                is = cl.getResourceAsStream(fileName);
            }
            if (is == null) {
                return null;
            }
            BufferedReader br = null;
            try {
                br = new BufferedReader(this.getInputStreamReader(is));
                template = this.loadTemplate(name, br);
            }
            catch (IOException ioe) {
                this.error("Problem reading template file: " + fileName, ioe);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException ioe2) {
                        this.error("Cannot close template file: " + fileName, ioe2);
                    }
                }
            }
            return template;
        }
        template = this.loadTemplate(name, this.rootDir + "/" + fileName);
        return template;
    }

    public String getFileNameFromTemplateName(String templateName) {
        return templateName + ".st";
    }

    public String getTemplateNameFromFileName(String fileName) {
        String name = fileName;
        int suffix = name.lastIndexOf(".st");
        if (suffix >= 0) {
            name = name.substring(0, suffix);
        }
        return name;
    }

    protected StringTemplate loadTemplate(String name, String fileName) {
        StringTemplate template;
        block4: {
            BufferedReader br = null;
            template = null;
            try {
                FileInputStream fin = new FileInputStream(fileName);
                InputStreamReader isr = this.getInputStreamReader(fin);
                br = new BufferedReader(isr);
                template = this.loadTemplate(name, br);
                br.close();
                br = null;
            }
            catch (IOException ioe) {
                if (br == null) break block4;
                try {
                    br.close();
                }
                catch (IOException ioe2) {
                    this.error("Cannot close template file: " + fileName);
                }
            }
        }
        return template;
    }

    protected InputStreamReader getInputStreamReader(InputStream in) {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(in, this.fileCharEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            this.error("Invalid file character encoding: " + this.fileCharEncoding);
        }
        return isr;
    }

    public String getFileCharEncoding() {
        return this.fileCharEncoding;
    }

    public void setFileCharEncoding(String fileCharEncoding) {
        this.fileCharEncoding = fileCharEncoding;
    }

    public synchronized StringTemplate defineTemplate(String name, String template) {
        if (name != null && name.indexOf(46) >= 0) {
            throw new IllegalArgumentException("cannot have '.' in template names");
        }
        StringTemplate st = this.createStringTemplate();
        st.setName(name);
        st.setGroup(this);
        st.setNativeGroup(this);
        st.setTemplate(template);
        st.setErrorListener(this.listener);
        this.templates.put(name, st);
        return st;
    }

    public StringTemplate defineRegionTemplate(String enclosingTemplateName, String regionName, String template, int type) {
        String mangledName = this.getMangledRegionName(enclosingTemplateName, regionName);
        StringTemplate regionST = this.defineTemplate(mangledName, template);
        regionST.setIsRegion(true);
        regionST.setRegionDefType(type);
        return regionST;
    }

    public StringTemplate defineRegionTemplate(StringTemplate enclosingTemplate, String regionName, String template, int type) {
        StringTemplate regionST = this.defineRegionTemplate(enclosingTemplate.getOutermostName(), regionName, template, type);
        enclosingTemplate.getOutermostEnclosingInstance().addRegionName(regionName);
        return regionST;
    }

    public StringTemplate defineImplicitRegionTemplate(StringTemplate enclosingTemplate, String name) {
        return this.defineRegionTemplate(enclosingTemplate, name, "", 1);
    }

    public String getMangledRegionName(String enclosingTemplateName, String name) {
        return "region__" + enclosingTemplateName + "__" + name;
    }

    public String getUnMangledTemplateName(String mangledName) {
        return mangledName.substring("region__".length(), mangledName.lastIndexOf("__"));
    }

    public synchronized StringTemplate defineTemplateAlias(String name, String target) {
        StringTemplate targetST = this.getTemplateDefinition(target);
        if (targetST == null) {
            this.error("cannot alias " + name + " to undefined template: " + target);
            return null;
        }
        this.templates.put(name, targetST);
        return targetST;
    }

    public synchronized boolean isDefinedInThisGroup(String name) {
        StringTemplate st = (StringTemplate)this.templates.get(name);
        if (st != null) {
            return !st.isRegion() || st.getRegionDefType() != 1;
        }
        return false;
    }

    public synchronized StringTemplate getTemplateDefinition(String name) {
        return (StringTemplate)this.templates.get(name);
    }

    public boolean isDefined(String name) {
        try {
            return this.lookupTemplate(name) != null;
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    protected void parseGroup(Reader r) {
        try {
            GroupLexer lexer = new GroupLexer(r);
            GroupParser parser = new GroupParser(lexer);
            parser.group(this);
        }
        catch (Exception e) {
            String name = "<unknown>";
            if (this.getName() != null) {
                name = this.getName();
            }
            this.error("problem parsing group " + name + ": " + e, e);
        }
    }

    protected void verifyInterfaceImplementations() {
        for (int i = 0; this.interfaces != null && i < this.interfaces.size(); ++i) {
            StringTemplateGroupInterface I = (StringTemplateGroupInterface)this.interfaces.get(i);
            List missing = I.getMissingTemplates(this);
            List mismatched = I.getMismatchedTemplates(this);
            if (missing != null) {
                this.error("group " + this.getName() + " does not satisfy interface " + I.getName() + ": missing templates " + missing);
            }
            if (mismatched == null) continue;
            this.error("group " + this.getName() + " does not satisfy interface " + I.getName() + ": mismatched arguments on these templates " + mismatched);
        }
    }

    public int getRefreshInterval() {
        return this.refreshIntervalInSeconds;
    }

    public void setRefreshInterval(int refreshInterval) {
        this.refreshIntervalInSeconds = refreshInterval;
    }

    public void setErrorListener(StringTemplateErrorListener listener) {
        this.listener = listener;
    }

    public StringTemplateErrorListener getErrorListener() {
        return this.listener;
    }

    public void setStringTemplateWriter(Class c) {
        this.userSpecifiedWriter = c;
    }

    public StringTemplateWriter getStringTemplateWriter(Writer w) {
        StringTemplateWriter stw = null;
        if (this.userSpecifiedWriter != null) {
            try {
                Constructor ctor = this.userSpecifiedWriter.getConstructor(Writer.class);
                stw = (StringTemplateWriter)ctor.newInstance(w);
            }
            catch (Exception e) {
                this.error("problems getting StringTemplateWriter", e);
            }
        }
        if (stw == null) {
            stw = new AutoIndentWriter(w);
        }
        return stw;
    }

    public void setAttributeRenderers(Map renderers) {
        this.attributeRenderers = renderers;
    }

    public void registerRenderer(Class attributeClassType, Object renderer) {
        if (this.attributeRenderers == null) {
            this.attributeRenderers = Collections.synchronizedMap(new HashMap());
        }
        this.attributeRenderers.put(attributeClassType, renderer);
    }

    public AttributeRenderer getAttributeRenderer(Class attributeClassType) {
        if (this.attributeRenderers == null) {
            if (this.superGroup == null) {
                return null;
            }
            return this.superGroup.getAttributeRenderer(attributeClassType);
        }
        AttributeRenderer renderer = (AttributeRenderer)this.attributeRenderers.get(attributeClassType);
        if (renderer == null && this.superGroup != null) {
            renderer = this.superGroup.getAttributeRenderer(attributeClassType);
        }
        return renderer;
    }

    public Map getMap(String name) {
        if (this.maps == null) {
            if (this.superGroup == null) {
                return null;
            }
            return this.superGroup.getMap(name);
        }
        Map m = (Map)this.maps.get(name);
        if (m == null && this.superGroup != null) {
            m = this.superGroup.getMap(name);
        }
        return m;
    }

    public void defineMap(String name, Map mapping) {
        this.maps.put(name, mapping);
    }

    public static void registerDefaultLexer(Class lexerClass) {
        defaultTemplateLexerClass = lexerClass;
    }

    public static void registerGroupLoader(StringTemplateGroupLoader loader) {
        groupLoader = loader;
    }

    public static StringTemplateGroup loadGroup(String name) {
        return StringTemplateGroup.loadGroup(name, null, null);
    }

    public static StringTemplateGroup loadGroup(String name, StringTemplateGroup superGroup) {
        return StringTemplateGroup.loadGroup(name, null, superGroup);
    }

    public static StringTemplateGroup loadGroup(String name, Class lexer, StringTemplateGroup superGroup) {
        if (groupLoader != null) {
            return groupLoader.loadGroup(name, lexer, superGroup);
        }
        return null;
    }

    public static StringTemplateGroupInterface loadInterface(String name) {
        if (groupLoader != null) {
            return groupLoader.loadInterface(name);
        }
        return null;
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String msg, Exception e) {
        if (this.listener != null) {
            this.listener.error(msg, e);
        } else {
            System.err.println("StringTemplate: " + msg);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public synchronized Set getTemplateNames() {
        return this.templates.keySet();
    }

    public void emitDebugStartStopStrings(boolean emit) {
        this.debugTemplateOutput = emit;
    }

    public void doNotEmitDebugStringsForTemplate(String templateName) {
        if (this.noDebugStartStopStrings == null) {
            this.noDebugStartStopStrings = new HashSet();
        }
        this.noDebugStartStopStrings.add(templateName);
    }

    public void emitTemplateStartDebugString(StringTemplate st, StringTemplateWriter out) throws IOException {
        if (this.noDebugStartStopStrings == null || !this.noDebugStartStopStrings.contains(st.getName())) {
            String groupPrefix = "";
            if (!st.getName().startsWith("if") && !st.getName().startsWith("else")) {
                groupPrefix = st.getNativeGroup() != null ? st.getNativeGroup().getName() + "." : st.getGroup().getName() + ".";
            }
            out.write("<" + groupPrefix + st.getName() + ">");
        }
    }

    public void emitTemplateStopDebugString(StringTemplate st, StringTemplateWriter out) throws IOException {
        if (this.noDebugStartStopStrings == null || !this.noDebugStartStopStrings.contains(st.getName())) {
            String groupPrefix = "";
            if (!st.getName().startsWith("if") && !st.getName().startsWith("else")) {
                groupPrefix = st.getNativeGroup() != null ? st.getNativeGroup().getName() + "." : st.getGroup().getName() + ".";
            }
            out.write("</" + groupPrefix + st.getName() + ">");
        }
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean showTemplatePatterns) {
        StringBuffer buf = new StringBuffer();
        Set templateNameSet = this.templates.keySet();
        ArrayList sortedNames = new ArrayList(templateNameSet);
        Collections.sort(sortedNames);
        Iterator iter = sortedNames.iterator();
        buf.append("group " + this.getName() + ";\n");
        StringTemplate formalArgs = new StringTemplate("$args;separator=\",\"$");
        while (iter.hasNext()) {
            String tname = (String)iter.next();
            StringTemplate st = (StringTemplate)this.templates.get(tname);
            if (st == NOT_FOUND_ST) continue;
            formalArgs = formalArgs.getInstanceOf();
            formalArgs.setAttribute("args", st.getFormalArguments());
            buf.append(tname + "(" + formalArgs + ")");
            if (showTemplatePatterns) {
                buf.append(" ::= <<");
                buf.append(st.getTemplate());
                buf.append(">>\n");
                continue;
            }
            buf.append('\n');
        }
        return buf.toString();
    }
}

