/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.shade.org.apache.commons.beanutils.converters;

import com.sforce.ws.shade.org.apache.commons.beanutils.ConversionException;
import com.sforce.ws.shade.org.apache.commons.beanutils.converters.AbstractArrayConverter;
import java.util.List;

public final class CharacterArrayConverter
extends AbstractArrayConverter {
    private static char[] model = new char[0];

    public CharacterArrayConverter() {
        this.defaultValue = null;
        this.useDefault = false;
    }

    public CharacterArrayConverter(Object defaultValue) {
        this.defaultValue = defaultValue;
        this.useDefault = true;
    }

    public Object convert(Class type, Object value) {
        if (value == null) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException("No value specified");
        }
        if (model.getClass() == value.getClass()) {
            return value;
        }
        if (AbstractArrayConverter.strings.getClass() == value.getClass()) {
            try {
                String[] values = (String[])value;
                char[] results = new char[values.length];
                int i = 0;
                while (i < values.length) {
                    results[i] = values[i].charAt(0);
                    ++i;
                }
                return results;
            }
            catch (Exception e) {
                if (this.useDefault) {
                    return this.defaultValue;
                }
                throw new ConversionException(value.toString(), e);
            }
        }
        try {
            List list = this.parseElements(value.toString());
            char[] results = new char[list.size()];
            int i = 0;
            while (i < results.length) {
                results[i] = ((String)list.get(i)).charAt(0);
                ++i;
            }
            return results;
        }
        catch (Exception e) {
            if (this.useDefault) {
                return this.defaultValue;
            }
            throw new ConversionException(value.toString(), e);
        }
    }
}

